/*
 * Decompiled with CFR 0.152.
 */
package org.knallgrau.utils.textcat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.knallgrau.utils.textcat.FingerPrint;
import org.knallgrau.utils.textcat.MyProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextCategorizer {
    private File confFile = null;
    private static final int UNKNOWN_LIMIT = 10;
    private final String jarConfFile = "org/knallgrau/utils/textcat/textcat.conf";
    private ArrayList<FingerPrint> categories = new ArrayList();
    static /* synthetic */ Class class$0;

    public TextCategorizer() {
        this.loadCategories();
    }

    public TextCategorizer(String confFile) {
        this.setConfFile(confFile);
    }

    public void setConfFile(String confFile) {
        this.confFile = new File(confFile);
        this.loadCategories();
    }

    private void loadCategories() {
        this.categories.clear();
        try {
            MyProperties properties = new MyProperties();
            if (this.confFile == null) {
                properties.load(TextCategorizer.class.getClassLoader().getResourceAsStream("org/knallgrau/utils/textcat/textcat.conf"));
            } else {
                properties.load(new FileInputStream(this.confFile.toString()));
            }
            for (Map.Entry entry : properties.entrySet()) {
                FingerPrint fp = this.confFile == null ? new FingerPrint(TextCategorizer.class.getClassLoader().getResourceAsStream((String)entry.getKey())) : new FingerPrint((String)entry.getKey());
                fp.setCategory((String)entry.getValue());
                this.categories.add(fp);
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }

    public String categorize(String text) {
        if (text.length() < 10) {
            return "unknown";
        }
        FingerPrint fp = new FingerPrint();
        fp.create(text);
        fp.categorize(this.categories);
        return fp.getCategory();
    }

    public String categorize(String text, int limit) {
        if (limit > text.length() - 1) {
            return this.categorize(text);
        }
        return this.categorize(text.substring(0, limit));
    }

    public Map<String, Integer> getCategoryDistances(String text) {
        if (this.categories.isEmpty()) {
            this.loadCategories();
        }
        FingerPrint fp = new FingerPrint();
        fp.create(text);
        fp.categorize(this.categories);
        return fp.getCategoryDistances();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        block9: {
            String s;
            byte[] data;
            block8: {
                data = new byte[1024];
                s = "";
                if (args.length == 0) break block8;
                if (!args[0].equals("-categorize")) break block9;
            }
            try {
                int read;
                while ((read = System.in.read(data)) != -1) {
                    s = String.valueOf(s) + new String(data, 0, read);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            TextCategorizer guesser = new TextCategorizer();
            System.out.println(guesser.categorize(s));
            return;
        }
        if (args.length > 1 && args[0].equals("-createfp")) {
            FingerPrint fp = new FingerPrint();
            fp.create(new File(args[1]));
            if (args.length > 2) {
                fp.setCategory(args[2]);
            } else {
                fp.setCategory(args[1].replaceAll("\\..*", ""));
            }
            fp.save();
            return;
        } else {
            System.out.println("Options:\n\n\t-categorize\tdetermines language of stdin\n\t-createfp <file> <category>\tcreates fingerprint from file");
        }
    }
}

