/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.categorization.listener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.categorization.service.DocumentCategorizationService;
import org.nuxeo.runtime.api.Framework;

public class DocumentCategorizationAsyncListener
implements PostCommitEventListener {
    protected static final Log log = LogFactory.getLog(DocumentCategorizationAsyncListener.class);
    protected static final String ALLREADY_CATEGORIZED_FLAG = DocumentCategorizationAsyncListener.class.getName();
    protected Set<String> eventNames = new HashSet<String>(Arrays.asList("documentCreated", "documentModified"));
    protected DocumentCategorizationService service;

    public void handleEvent(EventBundle events) throws ClientException {
        LinkedHashSet<DocumentModel> collectedDocuments = new LinkedHashSet<DocumentModel>(events.size());
        for (Event event : events) {
            DocumentEventContext docCtx;
            DocumentModel doc;
            EventContext ctx;
            if (!this.eventNames.contains(event.getName()) || (ctx = event.getContext()).hasProperty(ALLREADY_CATEGORIZED_FLAG) || !(ctx instanceof DocumentEventContext) || (doc = (docCtx = (DocumentEventContext)ctx).getSourceDocument()) == null) continue;
            ScopedMap contextData = doc.getContextData();
            contextData.putScopedValue(ScopeType.REQUEST, ALLREADY_CATEGORIZED_FLAG, (Serializable)Boolean.TRUE);
            collectedDocuments.add(doc);
        }
        if (!collectedDocuments.isEmpty()) {
            CoreSession session = ((DocumentModel)collectedDocuments.iterator().next()).getCoreSession();
            try {
                DocumentCategorizationService categorizationService = (DocumentCategorizationService)Framework.getService(DocumentCategorizationService.class);
                List<DocumentModel> documents = categorizationService.updateCategories(new ArrayList<DocumentModel>(collectedDocuments));
                if (!documents.isEmpty()) {
                    session.saveDocuments(documents.toArray(new DocumentModel[documents.size()]));
                    session.save();
                }
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
    }
}

