/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.categorization.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.platform.categorization.service.CategorizerDescriptor;
import org.nuxeo.ecm.platform.categorization.service.DocumentCategorizationService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class DocumentCategorizationServiceImpl
extends DefaultComponent
implements DocumentCategorizationService {
    public static final String CATEGORIZERS_XP_NAME = "categorizers";
    public static final String ANY2TEXT = "any2text";
    private static final Log log = LogFactory.getLog(DocumentCategorizationServiceImpl.class);
    protected Map<String, CategorizerDescriptor> mergedCategorizers;
    protected final List<CategorizerDescriptor> registeredCategorizers = new ArrayList<CategorizerDescriptor>();
    protected final BlobsExtractor extractor = new BlobsExtractor();
    protected ConversionService conversionService;

    public void registerExtension(Extension extension) {
        if (extension.getExtensionPoint().equals(CATEGORIZERS_XP_NAME)) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                if (!(contrib instanceof CategorizerDescriptor)) continue;
                this.registerCategorizerDescriptor((CategorizerDescriptor)contrib, extension);
            }
        }
    }

    public void unregisterExtension(Extension extension) {
        if (extension.getExtensionPoint().equals(CATEGORIZERS_XP_NAME)) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                if (!(contrib instanceof CategorizerDescriptor)) continue;
                this.unregisterCategorizerDescriptor((CategorizerDescriptor)contrib, extension);
            }
        }
    }

    protected void registerCategorizerDescriptor(CategorizerDescriptor descriptor, Extension extension) {
        descriptor.initializeInContext(extension.getContext());
        this.registeredCategorizers.add(descriptor);
        this.mergedCategorizers = null;
    }

    protected synchronized void unregisterCategorizerDescriptor(CategorizerDescriptor descriptor, Extension extension) {
        int index = this.registeredCategorizers.lastIndexOf(descriptor);
        if (index != -1) {
            this.registeredCategorizers.remove(index);
            this.mergedCategorizers = null;
        } else {
            log.warn((Object)String.format("no registered Categorizer under name '%s'", descriptor.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, CategorizerDescriptor> getMergedDescriptors() {
        if (this.mergedCategorizers == null) {
            DocumentCategorizationServiceImpl documentCategorizationServiceImpl = this;
            synchronized (documentCategorizationServiceImpl) {
                if (this.mergedCategorizers == null) {
                    this.mergedCategorizers = new LinkedHashMap<String, CategorizerDescriptor>();
                    for (CategorizerDescriptor descriptor : this.registeredCategorizers) {
                        String name = descriptor.getName();
                        if (descriptor.isEnabled()) {
                            CategorizerDescriptor previousDescriptor = this.mergedCategorizers.get(name);
                            CategorizerDescriptor mergedDescriptor = new CategorizerDescriptor();
                            mergedDescriptor.merge(previousDescriptor);
                            mergedDescriptor.merge(descriptor);
                            this.mergedCategorizers.put(name, mergedDescriptor);
                            continue;
                        }
                        this.mergedCategorizers.remove(name);
                    }
                }
            }
        }
        return this.mergedCategorizers;
    }

    @Override
    public List<DocumentModel> updateCategories(CoreSession session, List<DocumentRef> docRefs) {
        DocumentModelList documents = session.getDocuments(docRefs.toArray(new DocumentRef[docRefs.size()]));
        return this.updateCategories((List<DocumentModel>)documents);
    }

    @Override
    public List<DocumentModel> updateCategories(List<DocumentModel> documents) {
        LinkedHashSet<DocumentModel> impactedDocs = new LinkedHashSet<DocumentModel>();
        for (DocumentModel doc : documents) {
            LinkedList<CategorizerDescriptor> categorizersToApply = new LinkedList<CategorizerDescriptor>();
            for (CategorizerDescriptor categorizer : this.getMergedDescriptors().values()) {
                if (!categorizer.shouldProcess(doc)) continue;
                categorizersToApply.add(categorizer);
            }
            if (categorizersToApply.isEmpty()) continue;
            String textContent = this.extractTextContent(doc);
            for (CategorizerDescriptor categorizer : categorizersToApply) {
                if (textContent.length() <= categorizer.getMinTextLength()) continue;
                categorizer.processDocument(doc, textContent);
            }
            impactedDocs.add(doc);
        }
        return new ArrayList<DocumentModel>(impactedDocs);
    }

    public String extractTextContent(DocumentModel doc) {
        LinkedList<String> strings = new LinkedList<String>();
        strings.add(doc.getTitle());
        String description = (String)doc.getProperty("dc:description").getValue(String.class);
        if (description != null) {
            strings.add(description);
        }
        List blobs = this.extractor.getBlobs(doc);
        try {
            String noteContent = (String)((Object)doc.getPropertyValue("note:note"));
            StreamingBlob noteBlob = StreamingBlob.createFromString((String)noteContent, (String)"text/html");
            blobs.add(noteBlob);
        }
        catch (PropertyException pe) {
            // empty catch block
        }
        ConversionService conversionService = this.getConversionService();
        for (Blob blob : blobs) {
            try {
                SimpleBlobHolder bh = new SimpleBlobHolder(blob);
                BlobHolder result = conversionService.convert(ANY2TEXT, (BlobHolder)bh, null);
                if (result == null || (blob = result.getBlob()) == null) continue;
                String string = new String(blob.getByteArray(), "UTF-8");
                if (string.indexOf(0) >= 0) {
                    string = string.replace("\u0000", " ");
                }
                strings.add(string);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return StringUtils.join(strings, (String)"\n");
    }

    protected ConversionService getConversionService() {
        if (this.conversionService == null) {
            this.conversionService = (ConversionService)Framework.getService(ConversionService.class);
        }
        return this.conversionService;
    }
}

