/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.categorization.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.categorization.service.Categorizer;
import org.nuxeo.ecm.platform.categorization.service.CategorizerFactory;
import org.nuxeo.runtime.model.RuntimeContext;

@XObject(value="categorizer")
public class CategorizerDescriptor {
    public static final Log log = LogFactory.getLog(CategorizerDescriptor.class);
    protected static int DEFAULT_MAX_SUGGESTIONS = 3;
    protected static int DEFAULT_MIN_TEXT_LENGTH = 50;
    protected RuntimeContext runtimeContext;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@property")
    protected String propertyXPath;
    @XNode(value="@factory")
    protected String className;
    @XNode(value="@model")
    protected String modelFile;
    @XNode(value="@enabled")
    protected boolean enabled = true;
    @XNode(value="@maxSuggestions")
    protected int maxSuggestions = DEFAULT_MAX_SUGGESTIONS;
    @XNode(value="@minTextLength")
    protected int minTextLength = DEFAULT_MIN_TEXT_LENGTH;
    @XNode(value="@precisionThreshold")
    protected Double precisionThreshold;
    @XNodeList(value="skip/facet@name", type=ArrayList.class, componentType=String.class)
    public List<String> skipFacets = new ArrayList<String>();
    @XNodeMap(value="mapping/outcome", key="@name", type=HashMap.class, componentType=String.class)
    Map<String, String> mapping = new HashMap<String, String>();
    protected Categorizer categorizer;
    protected CategorizerFactory factory;

    public String getName() {
        return this.name;
    }

    public void initializeInContext(RuntimeContext context) {
        if (this.className != null) {
            try {
                this.factory = (CategorizerFactory)context.loadClass(this.className).newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void processDocument(DocumentModel doc, String textContent) throws PropertyException, ClientException {
        Property property;
        if (this.categorizer == null) {
            this.categorizer = this.factory.loadInstance(this.modelFile, true);
        }
        List<String> suggestedCategories = this.categorizer.guessCategories(textContent, this.maxSuggestions, this.precisionThreshold);
        log.debug((Object)String.format("Sugestions for document '%s' and property '%s' with textcontent of length %d: [%s]", doc.getTitle(), this.propertyXPath, textContent.length(), StringUtils.join(suggestedCategories, (String)", ")));
        List<String> propertyValues = new ArrayList<String>(this.maxSuggestions);
        if (!this.mapping.isEmpty()) {
            for (String suggestion : suggestedCategories) {
                String property2 = this.mapping.get(suggestion);
                if (property2 == null) continue;
                propertyValues.add(property2);
            }
        } else {
            propertyValues.addAll(suggestedCategories);
        }
        if (propertyValues.isEmpty()) {
            return;
        }
        if (propertyValues.size() > this.maxSuggestions) {
            propertyValues = propertyValues.subList(0, this.maxSuggestions);
        }
        if ((property = doc.getProperty(this.propertyXPath)).isList()) {
            doc.setPropertyValue(this.propertyXPath, (Serializable)((Object)propertyValues));
        } else {
            doc.setPropertyValue(this.propertyXPath, (Serializable)propertyValues.get(0));
        }
    }

    public boolean shouldProcess(DocumentModel doc) throws ClientException {
        if (this.skipFacets != null) {
            for (String facetToSkip : this.skipFacets) {
                if (!doc.hasFacet(facetToSkip)) continue;
                return false;
            }
        }
        try {
            Property property = doc.getProperty(this.propertyXPath);
            if (property.getValue() == null) {
                return true;
            }
            if (property.isList()) {
                List values = (List)property.getValue(List.class);
                if (values.isEmpty()) {
                    return true;
                }
            } else {
                if (property.isComplex()) {
                    throw new ClientException(this.propertyXPath + " is a complex type field and hence is not suitable for text based categorization");
                }
                if (property.getValue().toString().trim().length() == 0) {
                    return true;
                }
            }
        }
        catch (PropertyException e) {
            return false;
        }
        return false;
    }

    public int getMinTextLength() {
        return this.minTextLength;
    }

    public void setMinTextLength(int minTextLength) {
        this.minTextLength = minTextLength;
    }

    public CategorizerDescriptor merge(CategorizerDescriptor other) {
        if (other != null) {
            if (other.propertyXPath != null) {
                this.propertyXPath = other.propertyXPath;
            }
            if (other.className != null) {
                this.className = other.className;
            }
            if (other.categorizer != null) {
                this.categorizer = other.categorizer;
            }
            if (other.factory != null) {
                this.factory = other.factory;
            }
            if (other.maxSuggestions != DEFAULT_MAX_SUGGESTIONS) {
                this.maxSuggestions = other.maxSuggestions;
            }
            if (other.minTextLength != DEFAULT_MIN_TEXT_LENGTH) {
                this.minTextLength = other.minTextLength;
            }
            if (other.precisionThreshold != null) {
                this.precisionThreshold = other.precisionThreshold;
            }
            if (other.modelFile != null) {
                this.modelFile = other.modelFile;
            }
            if (!other.mapping.isEmpty()) {
                this.mapping = other.mapping;
            }
            if (!other.skipFacets.isEmpty()) {
                this.skipFacets = other.skipFacets;
            }
        }
        return this;
    }
}

