/*
 * Decompiled with CFR 0.152.
 */
package org.knallgrau.utils.textcat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.knallgrau.utils.textcat.MyProperties;
import org.knallgrau.utils.textcat.NGramEntryComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FingerPrint
extends Hashtable<String, Integer> {
    private static final long serialVersionUID = -2790111752993314113L;
    private Pattern pattern = Pattern.compile("^_?[^0-9\\?!\\-_/]*_?$");
    private String category = "unknown";
    private HashMap<String, Integer> categoryDistances = new HashMap();
    private TreeSet<Map.Entry<String, Integer>> entries;

    public FingerPrint() {
    }

    public FingerPrint(String file) {
        this.loadFingerPrintFromFile(file);
    }

    public FingerPrint(InputStream is) {
        this.loadFingerPrintFromInputStream(is);
    }

    public void create(File file) {
        char[] data = new char[1024];
        String s = "";
        try {
            int read;
            FileReader fr = new FileReader(file);
            while ((read = fr.read(data)) != -1) {
                s = String.valueOf(s) + new String(data, 0, read);
            }
            fr.close();
            this.create(s);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void create(String text) {
        this.clear();
        this.computeNGrams(1, 5, text);
        if (this.containsKey("_")) {
            int blanksScore = (Integer)this.remove("_");
            this.put("_", blanksScore / 2);
        }
        this.entries = new TreeSet<Map.Entry<String, Integer>>(new NGramEntryComparator());
        this.entries.addAll(this.entrySet());
    }

    private void computeNGrams(int startOrder, int maxOrder, String text) {
        String[] tokens = text.split("\\s");
        int order = startOrder;
        while (order <= maxOrder) {
            String[] stringArray = tokens;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String token = stringArray[n];
                token = "_" + token + "_";
                int i = 0;
                while (i < token.length() - order + 1) {
                    String ngram = token.substring(i, i + order);
                    Matcher matcher = this.pattern.matcher(ngram);
                    if (matcher.find()) {
                        if (!this.containsKey(ngram)) {
                            this.put(ngram, 1);
                        } else {
                            int score = (Integer)this.remove(ngram);
                            this.put(ngram, ++score);
                        }
                    }
                    ++i;
                }
                ++n;
            }
            ++order;
        }
    }

    public Map<String, Integer> categorize(Collection<FingerPrint> categories) {
        int minDistance = Integer.MAX_VALUE;
        for (FingerPrint fp : categories) {
            int distance = this.getDistance(fp);
            this.getCategoryDistances().put(fp.getCategory(), distance);
            if (distance >= minDistance) continue;
            minDistance = distance;
            this.category = fp.getCategory();
        }
        return this.getCategoryDistances();
    }

    public Map<String, Integer> getCategoryDistances() {
        return this.categoryDistances;
    }

    private int getDistance(FingerPrint category) {
        int distance = 0;
        int count = 0;
        for (Map.Entry<String, Integer> entry : this.entries) {
            String ngram = entry.getKey();
            if (++count > 400) break;
            if (!category.containsKey(ngram)) {
                distance += category.size();
                continue;
            }
            distance += Math.abs(this.getPosition(ngram) - category.getPosition(ngram));
        }
        return distance;
    }

    private void loadFingerPrintFromInputStream(InputStream is) {
        this.entries = new TreeSet<Map.Entry<String, Integer>>(new NGramEntryComparator());
        MyProperties properties = new MyProperties();
        properties.load(is);
        for (Map.Entry entry : properties.entrySet()) {
            this.put((String)entry.getKey(), Integer.parseInt((String)entry.getValue()));
        }
        this.entries.addAll(this.entrySet());
    }

    private void loadFingerPrintFromFile(String file) {
        File fpFile = new File(file);
        if (!fpFile.isDirectory()) {
            try {
                FileInputStream fis = new FileInputStream(file.toString());
                this.loadFingerPrintFromInputStream(fis);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public int getPosition(String key) {
        int pos = 1;
        int value = this.entries.first().getValue();
        for (Map.Entry<String, Integer> entry : this.entries) {
            if (value != entry.getValue()) {
                value = entry.getValue();
                ++pos;
            }
            if (!entry.getKey().equals(key)) continue;
            return pos;
        }
        return -1;
    }

    public void save() {
        File file = new File(String.valueOf(this.getCategory()) + ".lm");
        try {
            if (file.createNewFile()) {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(this.toString().getBytes());
                fos.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public String toString() {
        String s = "";
        for (Map.Entry<String, Integer> entry : this.entries) {
            s = String.valueOf(s) + entry.getKey() + "\t" + entry.getValue() + "\n";
        }
        return s;
    }

    protected void setCategory(String category) {
        this.category = category;
    }
}

