/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.io.Serializable;
import java.util.HashMap;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.PropertyFactory;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public class DocumentPartImpl
extends ComplexProperty
implements DocumentPart {
    private static final long serialVersionUID = 1L;
    protected Schema schema;
    protected boolean clearComplexPropertyBeforeSet;

    public DocumentPartImpl(Schema schema) {
        super(null, 16);
        this.schema = schema;
        this.clearComplexPropertyBeforeSet = ((SchemaManager)Framework.getService(SchemaManager.class)).getClearComplexPropertyBeforeSet();
    }

    @Override
    public void internalSetValue(Serializable value) throws PropertyException {
    }

    @Override
    public Serializable getValue() throws PropertyException {
        return this.internalGetValue();
    }

    @Override
    public Serializable getValueForWrite() throws PropertyException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (Property property : this.getChildren()) {
            map.put(property.getName(), property.getValueForWrite());
        }
        return map;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.schema.getName();
    }

    public Schema getType() {
        return this.schema;
    }

    @Override
    public Field getField() {
        throw new UnsupportedOperationException("Document parts are not bound to schema fields");
    }

    @Override
    public Path collectPath(Path path) {
        return path;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void accept(PropertyVisitor visitor, Object arg) throws PropertyException {
        this.visitChildren(visitor, arg);
    }

    @Override
    public Property createProperty(Property parent, Field field) {
        return this.createProperty(parent, field, 0);
    }

    @Override
    public Property createProperty(Property parent, Field field, int flags) {
        return PropertyFactory.createProperty(parent, field, flags);
    }

    @Override
    public boolean getClearComplexPropertyBeforeSet() {
        return this.clearComplexPropertyBeforeSet;
    }

    public boolean isSameAs(DocumentPart dp) {
        if (dp == null) {
            return false;
        }
        if (dp instanceof ComplexProperty) {
            return this.getNonPhantomChildren().equals(((ComplexProperty)((Object)dp)).getNonPhantomChildren());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getName() + (this.isDirty() ? "*" : "") + ", " + this.children + ')';
    }
}

