/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;

public abstract class AbstractBlobGarbageCollector
implements BinaryGarbageCollector {
    protected volatile long startTime;
    protected BinaryManagerStatus status;
    protected Set<String> marked;
    protected Set<String> toDelete;

    @Override
    public boolean isInProgress() {
        return this.startTime != 0L;
    }

    @Override
    public void start() {
        if (this.startTime != 0L) {
            throw new NuxeoException("Already started");
        }
        this.startTime = System.currentTimeMillis();
        this.status = new BinaryManagerStatus();
        this.marked = null;
        this.computeToDelete();
        if (this.marked == null && this.toDelete == null) {
            throw new IllegalStateException("New class must define 'toDelete'");
        }
        if (this.marked != null && this.toDelete != null) {
            throw new IllegalStateException("New class must not define 'marked'");
        }
    }

    public void computeToDelete() {
        this.marked = new HashSet<String>();
        this.toDelete = null;
    }

    @Override
    public void stop(boolean delete) {
        if (this.startTime == 0L) {
            throw new NuxeoException("Not started");
        }
        try {
            this.removeUnmarkedBlobsAndUpdateStatus(delete);
        }
        finally {
            this.marked = null;
            this.toDelete = null;
            this.status.gcDuration = System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
        }
    }

    public void removeUnmarkedBlobsAndUpdateStatus(boolean delete) {
        Set<String> unmarked = this.getUnmarkedBlobsAndUpdateStatus();
        if (delete) {
            this.removeBlobs(unmarked);
        }
    }

    public Set<String> getUnmarkedBlobsAndUpdateStatus() {
        throw new UnsupportedOperationException();
    }

    public void removeBlobs(Set<String> keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mark(String digest) {
        if (this.marked != null) {
            this.marked.add(digest);
        } else {
            this.toDelete.remove(digest);
        }
    }

    @Override
    public BinaryManagerStatus getStatus() {
        return this.status;
    }
}

