/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.KeyStrategyDocId;

public class BlobWriteContext {
    public final BlobContext blobContext;
    public final KeyStrategy.WriteObserver writeObserver;
    public final Supplier<String> keyComputer;
    public final KeyStrategy keyStrategy;
    protected Path file;

    public BlobWriteContext(BlobContext blobContext, KeyStrategy.WriteObserver writeObserver, Supplier<String> keyComputer, KeyStrategy keyStrategy) {
        this.blobContext = blobContext;
        this.writeObserver = writeObserver;
        this.keyComputer = keyComputer;
        this.keyStrategy = keyStrategy;
    }

    public BlobWriteContext copyWithKey(String key) {
        BlobWriteContext context = new BlobWriteContext(this.blobContext, this.writeObserver, () -> key, KeyStrategyDocId.instance());
        context.setFile(this.file);
        return context;
    }

    public BlobWriteContext copyWithNoWriteObserverAndKey(String key) {
        BlobWriteContext context = new BlobWriteContext(this.blobContext, null, () -> key, null);
        context.setFile(this.file);
        return context;
    }

    public boolean useDeDuplication() {
        return this.keyStrategy.useDeDuplication();
    }

    public String getKey() {
        return this.keyComputer.get();
    }

    public void setFile(Path file) {
        this.file = file;
    }

    public Path getFile() {
        return this.file;
    }

    public InputStream getStream() throws IOException {
        return this.file == null ? this.blobContext.blob.getStream() : Files.newInputStream(this.file, new OpenOption[0]);
    }
}

