/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.BoundedInputStream;

public class ByteRange {
    protected final long start;
    protected final long end;

    protected ByteRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public static ByteRange inclusive(long start, long end) {
        return new ByteRange(start, end);
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLength() {
        return this.end - this.start + 1L;
    }

    public InputStream forStream(InputStream stream) throws IOException {
        try {
            long n;
            for (long remain = this.getStart(); remain > 0L; remain -= n) {
                n = stream.skip(remain);
                if (n < 0L) {
                    throw new EOFException();
                }
                if (n != 0L) continue;
                throw new IOException("Failed to skip in stream");
            }
        }
        catch (IOException e) {
            stream.close();
            throw e;
        }
        return new BoundedInputStream(stream, this.getLength());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.start + '-' + this.end + ')';
    }
}

