/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.AbstractBlobGarbageCollector;
import org.nuxeo.ecm.core.blob.AbstractBlobStore;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobUpdateContext;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.ByteRange;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.KeyStrategyDigest;
import org.nuxeo.ecm.core.blob.PropertyBasedConfiguration;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.runtime.api.Framework;

public class InMemoryBlobStore
extends AbstractBlobStore {
    private static final Logger log = LogManager.getLogger(InMemoryBlobStore.class);
    protected static final Random RANDOM = new Random();
    protected Map<String, byte[]> map = new ConcurrentHashMap<String, byte[]>();
    protected Map<String, Boolean> legalHold = new ConcurrentHashMap<String, Boolean>();
    protected final InMemoryBlobGarbageCollector gc = new InMemoryBlobGarbageCollector();
    protected final boolean emulateNoStream;
    protected final boolean emulateLocalFile;
    protected final boolean emulateVersioning;
    protected final boolean allowByteRange;

    public InMemoryBlobStore(String name, KeyStrategy keyStrategy) {
        this(name, null, keyStrategy, false, false);
    }

    public InMemoryBlobStore(String name, PropertyBasedConfiguration config, KeyStrategy keyStrategy) {
        this(name, config, keyStrategy, false, false);
    }

    protected InMemoryBlobStore(String name, KeyStrategy keyStrategy, boolean emulateNoStream, boolean emulateLocalFile) {
        this(name, null, keyStrategy, emulateNoStream, emulateLocalFile);
    }

    protected InMemoryBlobStore(String name, PropertyBasedConfiguration config, KeyStrategy keyStrategy, boolean emulateNoStream, boolean emulateLocalFile) {
        super(name, keyStrategy);
        this.emulateNoStream = emulateNoStream;
        this.emulateLocalFile = emulateLocalFile;
        this.emulateVersioning = config != null && config.getBooleanProperty("emulateVersioning");
        this.allowByteRange = config != null && config.getBooleanProperty("allowByteRange");
    }

    @Override
    public boolean hasVersioning() {
        return this.emulateVersioning;
    }

    @Override
    protected String writeBlobGeneric(BlobWriteContext blobWriteContext) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transfer(blobWriteContext, baos);
        String key = blobWriteContext.getKey();
        if (this.hasVersioning()) {
            key = key + '@' + RANDOM.nextLong();
        }
        this.map.put(key, baos.toByteArray());
        return key;
    }

    @Override
    public void writeBlobProperties(BlobUpdateContext blobUpdateContext) throws IOException {
        String key = blobUpdateContext.key;
        if (blobUpdateContext.updateLegalHold != null) {
            boolean hold = blobUpdateContext.updateLegalHold.hold;
            this.legalHold.put(key, hold);
        }
    }

    @Override
    public boolean copyBlobIsOptimized(BlobStore sourceStore) {
        return sourceStore.unwrap() instanceof InMemoryBlobStore;
    }

    @Override
    public String copyOrMoveBlob(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        String returnedKey = this.copyBlob(key, sourceStore, sourceKey);
        if (returnedKey != null && atomicMove) {
            sourceStore.deleteBlob(sourceKey);
        }
        return returnedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String copyBlob(String key, BlobStore sourceStore, String sourceKey) throws IOException {
        BlobStore.OptionalOrUnknown<InputStream> streamOpt = sourceStore.getStream(sourceKey);
        if (streamOpt.isKnown()) {
            byte[] bytes;
            if (!streamOpt.isPresent()) {
                return null;
            }
            try (InputStream stream = streamOpt.get();){
                bytes = IOUtils.toByteArray((InputStream)stream);
            }
            return this.putBytes(key, bytes);
        }
        BlobStore.OptionalOrUnknown<Path> fileOpt = sourceStore.getFile(sourceKey);
        if (fileOpt.isKnown()) {
            if (!fileOpt.isPresent()) {
                return null;
            }
            byte[] bytes = Files.readAllBytes(fileOpt.get());
            return this.putBytes(key, bytes);
        }
        Path tmp = Files.createTempFile("bin_", ".tmp", new FileAttribute[0]);
        try {
            boolean found = sourceStore.readBlob(sourceKey, tmp);
            if (!found) {
                String string = null;
                return string;
            }
            byte[] bytes = Files.readAllBytes(tmp);
            String string = this.putBytes(key, bytes);
            return string;
        }
        finally {
            try {
                Files.delete(tmp);
            }
            catch (IOException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
    }

    protected String putBytes(String key, byte[] bytes) {
        if (key == null) {
            String digestAlgorithm = ((KeyStrategyDigest)this.keyStrategy).digestAlgorithm;
            key = new DigestUtils(digestAlgorithm).digestAsHex(bytes);
        }
        this.map.put(key, bytes);
        return key;
    }

    protected ByteArrayInputStream getStreamInternal(String key) {
        ByteRange byteRange;
        if (this.allowByteRange) {
            MutableObject keyHolder = new MutableObject((Object)key);
            byteRange = InMemoryBlobStore.getByteRangeFromKey((MutableObject<String>)keyHolder);
            key = (String)keyHolder.getValue();
        } else {
            byteRange = null;
        }
        byte[] bytes = this.map.get(key);
        if (bytes == null) {
            return null;
        }
        if (byteRange == null) {
            return new ByteArrayInputStream(bytes);
        }
        return new ByteArrayInputStream(bytes, (int)byteRange.getStart(), (int)byteRange.getLength());
    }

    @Override
    public BlobStore.OptionalOrUnknown<Path> getFile(String key) {
        if (!this.emulateLocalFile) {
            return BlobStore.OptionalOrUnknown.unknown();
        }
        ByteArrayInputStream stream = this.getStreamInternal(key);
        if (stream == null) {
            return BlobStore.OptionalOrUnknown.missing();
        }
        try {
            Path tmp = Files.createTempFile("tmp_", ".tmp", new FileAttribute[0]);
            Framework.trackFile((File)tmp.toFile(), (Object)tmp);
            FileUtils.copyToFile((InputStream)stream, (File)tmp.toFile());
            return BlobStore.OptionalOrUnknown.of(tmp);
        }
        catch (IOException e) {
            throw new NuxeoException(e);
        }
    }

    @Override
    public BlobStore.OptionalOrUnknown<InputStream> getStream(String key) throws IOException {
        if (this.emulateNoStream) {
            return BlobStore.OptionalOrUnknown.unknown();
        }
        ByteArrayInputStream stream = this.getStreamInternal(key);
        if (stream == null) {
            return BlobStore.OptionalOrUnknown.missing();
        }
        return BlobStore.OptionalOrUnknown.of(stream);
    }

    @Override
    public boolean readBlob(String key, Path dest) throws IOException {
        ByteArrayInputStream stream = this.getStreamInternal(key);
        if (stream == null) {
            return false;
        }
        Files.copy(stream, dest, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    @Override
    public void deleteBlob(String key) {
        this.map.remove(key);
        this.legalHold.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.legalHold.clear();
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.gc;
    }

    public class InMemoryBlobGarbageCollector
    extends AbstractBlobGarbageCollector {
        @Override
        public String getId() {
            return this.toString();
        }

        @Override
        public void computeToDelete() {
            this.toDelete = new HashSet();
            for (Map.Entry<String, byte[]> es : InMemoryBlobStore.this.map.entrySet()) {
                String key = es.getKey();
                byte[] bytes = es.getValue();
                this.status.sizeBinaries += (long)bytes.length;
                ++this.status.numBinaries;
                this.toDelete.add(key);
            }
        }

        @Override
        public void removeUnmarkedBlobsAndUpdateStatus(boolean delete) {
            for (String key : this.toDelete) {
                byte[] bytes = InMemoryBlobStore.this.map.get(key);
                if (bytes == null) continue;
                int length = bytes.length;
                this.status.sizeBinariesGC += (long)length;
                ++this.status.numBinariesGC;
                this.status.sizeBinaries -= (long)length;
                --this.status.numBinaries;
                if (!delete) continue;
                InMemoryBlobStore.this.map.remove(key);
                InMemoryBlobStore.this.legalHold.remove(key);
            }
        }
    }
}

