/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.api.Framework;

public class PropertyBasedConfiguration {
    private static final Logger log = LogManager.getLogger(PropertyBasedConfiguration.class);
    public final String systemPropertyPrefix;
    public final Map<String, String> properties;

    public PropertyBasedConfiguration(String systemPropertyPrefix, Map<String, String> properties) {
        this.systemPropertyPrefix = systemPropertyPrefix;
        this.properties = properties;
    }

    public String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    public String getProperty(String propertyName, String defaultValue) {
        String propValue = this.properties.get(propertyName);
        if (StringUtils.isNotBlank((CharSequence)propValue)) {
            return propValue;
        }
        if (this.systemPropertyPrefix != null && StringUtils.isNotBlank((CharSequence)(propValue = Framework.getProperty((String)(this.systemPropertyPrefix + "." + propertyName))))) {
            return propValue;
        }
        return defaultValue;
    }

    public long getLongProperty(String key) {
        String s = this.getProperty(key);
        long value = -1L;
        if (!StringUtils.isBlank((CharSequence)s)) {
            try {
                value = Long.parseLong(s.trim());
            }
            catch (NumberFormatException e) {
                log.error("Cannot parse long " + key + ": " + s);
            }
        }
        return value;
    }

    public int getIntProperty(String key) {
        String s = this.getProperty(key);
        int value = -1;
        if (!StringUtils.isBlank((CharSequence)s)) {
            try {
                value = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException e) {
                log.error("Cannot parse integer " + key + ": " + s);
            }
        }
        return value;
    }

    public boolean getBooleanProperty(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }
}

