/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import java.util.UUID;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public interface NuxeoPrincipal
extends Principal,
Serializable {
    public static final String PREFIX = "user:";
    public static final String TRANSIENT_USER_PREFIX = "transient/";
    @Deprecated
    public static final String TRANSIENT_USER_FORMAT = "transient/%s/%s";
    public static final String TRANSIENT_USERNAME_UNIQUE_PROP = "nuxeo.transient.username.unique";

    public String getFirstName();

    public String getLastName();

    public String getPassword();

    public String getCompany();

    public String getEmail();

    public List<String> getGroups();

    public List<String> getAllGroups();

    public boolean isMemberOf(String var1);

    public List<String> getRoles();

    public void setName(String var1);

    public void setFirstName(String var1);

    public void setLastName(String var1);

    public void setGroups(List<String> var1);

    public void setRoles(List<String> var1);

    public void setCompany(String var1);

    public void setPassword(String var1);

    public void setEmail(String var1);

    public String getPrincipalId();

    public void setPrincipalId(String var1);

    public DocumentModel getModel();

    public void setModel(DocumentModel var1);

    public boolean isAdministrator();

    public String getTenantId();

    public boolean isAnonymous();

    public String getOriginatingUser();

    public void setOriginatingUser(String var1);

    public String getActingUser();

    public boolean isTransient();

    public static boolean isTransientUsername(String username) {
        return username != null && username.startsWith(TRANSIENT_USER_PREFIX);
    }

    public static String computeTransientUsername(String baseUsername) {
        if (baseUsername != null && !baseUsername.startsWith(TRANSIENT_USER_PREFIX)) {
            StringBuilder sb = new StringBuilder(TRANSIENT_USER_PREFIX);
            sb.append(baseUsername);
            if (((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanPropertyTrue(TRANSIENT_USERNAME_UNIQUE_PROP)) {
                String uuid = UUID.randomUUID().toString();
                uuid = uuid.replaceAll("-", "").substring(0, 16);
                sb.append("/");
                sb.append(uuid);
            }
            return sb.toString();
        }
        return baseUsername;
    }
}

