/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;

public class ByteArrayBlob
extends AbstractBlob
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final byte[] bytes;

    public ByteArrayBlob(byte[] bytes) {
        this(bytes, null, null);
    }

    public ByteArrayBlob(byte[] bytes, String mimeType) {
        this(bytes, mimeType, null);
    }

    public ByteArrayBlob(byte[] bytes, String mimeType, String encoding) {
        if (bytes == null) {
            throw new NullPointerException("null bytes");
        }
        this.bytes = bytes;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    @Override
    public long getLength() {
        return this.bytes.length;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public byte[] getByteArray() {
        return this.bytes;
    }

    @Override
    public String getString() throws IOException {
        return new String(this.bytes, this.getEncoding() == null ? "UTF-8" : this.getEncoding());
    }
}

