/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;

public class ZipEntryBlob
extends AbstractBlob
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final ZipFile zipFile;
    protected final ZipEntry zipEntry;
    protected final Blob zipBlob;
    protected final String entryName;

    public ZipEntryBlob(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
        this.zipBlob = null;
        this.entryName = null;
    }

    public ZipEntryBlob(Blob zipBlob, String entryName) {
        this.zipFile = null;
        this.zipEntry = null;
        this.zipBlob = zipBlob;
        this.entryName = entryName;
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.zipBlob == null) {
            return this.zipFile.getInputStream(this.zipEntry);
        }
        return ZipEntryInputStream.of(this.zipBlob, this.entryName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLength() {
        if (this.zipBlob == null) {
            return this.zipEntry.getSize();
        }
        File file = this.zipBlob.getFile();
        if (file != null) {
            try (ZipFile zf = new ZipFile(file);){
                ZipEntry entry = zf.getEntry(this.entryName);
                long l = entry == null ? 0L : entry.getSize();
                return l;
            }
            catch (IOException e) {
                throw new NuxeoException(e);
            }
        }
        try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(this.zipBlob.getStream()));){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.getName().equals(this.entryName)) continue;
                long l = entry.getSize();
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (IOException e) {
            throw new NuxeoException(e);
        }
    }

    @Override
    public String getFilename() {
        return this.entryName != null ? this.entryName : super.getFilename();
    }

    public static class ZipEntryInputStream
    extends ProxyInputStream {
        protected final List<Closeable> closeables;

        public static ZipEntryInputStream of(Blob zipBlob, String entryName) throws IOException {
            InputStream in;
            ArrayList<Closeable> closeables = new ArrayList<Closeable>(2);
            try {
                CloseableFile closeableFile = zipBlob.getCloseableFile();
                closeables.add(closeableFile);
                ZipFile zipFile = new ZipFile(closeableFile.getFile());
                closeables.add(zipFile);
                in = zipFile.getInputStream(zipFile.getEntry(entryName));
            }
            catch (IOException ioe) {
                try {
                    ZipEntryInputStream.close(closeables);
                }
                catch (IOException e) {
                    ioe.addSuppressed(e);
                }
                throw ioe;
            }
            return new ZipEntryInputStream(in, closeables);
        }

        protected ZipEntryInputStream(InputStream in, List<Closeable> closeables) {
            super(in);
            this.closeables = closeables;
        }

        public void close() throws IOException {
            ArrayList<Closeable> closing = new ArrayList<Closeable>(3);
            closing.add(() -> super.close());
            closing.addAll(this.closeables);
            this.closeables.clear();
            ZipEntryInputStream.close(closing);
        }

        protected static void close(List<Closeable> closeables) throws IOException {
            IOException ioe = null;
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (ioe == null) {
                        ioe = e;
                        continue;
                    }
                    ioe.addSuppressed(e);
                }
            }
            if (ioe != null) {
                throw ioe;
            }
        }
    }
}

