/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.AbstractProperty;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BinaryProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BooleanProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.DateProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.DoubleProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.ExternalBlobProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.LongProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.StringProperty;
import org.nuxeo.ecm.core.schema.PropertyCharacteristicHandler;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class PropertyFactory {
    private PropertyFactory() {
    }

    public static Property createProperty(Property parent, Field field, int f) {
        Type type;
        int flags = f;
        if (parent instanceof AbstractProperty) {
            if (((AbstractProperty)parent).areFlagsSet(64L)) {
                flags |= 0x40;
            } else if ((flags & 0x40) == 0) {
                Schema schema = parent.getSchema();
                StringBuilder xpath = new StringBuilder();
                if (parent.getParent() != null) {
                    xpath.append(parent.getXPath()).append('/');
                }
                xpath.append(field.getName().getLocalName());
                PropertyCharacteristicHandler propertyHandler = (PropertyCharacteristicHandler)Framework.getService(PropertyCharacteristicHandler.class);
                if (propertyHandler.isSecured(schema.getName(), xpath.toString())) {
                    flags |= 0x40;
                }
            }
        }
        if ((type = field.getType()) instanceof SimpleTypeImpl) {
            type = type.getSuperType();
        }
        switch (type.getName()) {
            case "string": {
                return new StringProperty(parent, field, flags);
            }
            case "integer": 
            case "long": {
                return new LongProperty(parent, field, flags);
            }
            case "double": {
                return new DoubleProperty(parent, field, flags);
            }
            case "boolean": {
                return new BooleanProperty(parent, field, flags);
            }
            case "date": {
                return new DateProperty(parent, field, flags);
            }
            case "binary": {
                return new BinaryProperty(parent, field, flags);
            }
            case "content": {
                return new BlobProperty(parent, field, flags);
            }
            case "externalcontent": {
                return new ExternalBlobProperty(parent, field, flags);
            }
        }
        if (type.isSimpleType()) {
            return new ScalarProperty(parent, field, flags);
        }
        if (type.isComplexType()) {
            return new MapProperty(parent, field, flags);
        }
        if (type.isListType()) {
            if (((ListType)type).isArray()) {
                return new ArrayProperty(parent, field, flags);
            }
            return new ListProperty(parent, field, flags);
        }
        throw new IllegalArgumentException("Unsupported field type: " + field.getType().getName());
    }
}

