/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.BlobProviderDescriptor;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobStoreBlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryBlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.kv.KeyValueStoreProvider;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class BlobManagerComponent
extends DefaultComponent
implements BlobManager {
    private static final Logger log = LogManager.getLogger(BlobManagerComponent.class);
    protected static final String XP = "configuration";
    public static final String DEFAULT_ID = "default";
    public static final String TRANSIENT_ID_PREFIX = "transient";
    public static final String BLOB_KEY_REPLACEMENT_KV = "blobKeyReplacement";
    protected static final Duration BLOB_KEY_REPLACEMENT_TTL = Duration.ofHours(1L);
    protected static final String BLOB_DELETION_KV = "blobToDelete";
    protected static final String BLOB_DELETION_DELAY_PROP = "nuxeo.blobmanager.delete.delay";
    protected static final Duration BLOB_DELETION_DELAY_DEFAULT = Duration.ofHours(1L);
    protected BlobProviderDescriptorRegistry blobProviderDescriptorsRegistry = new BlobProviderDescriptorRegistry();
    protected Map<String, BlobProvider> blobProviders = new HashMap<String, BlobProvider>();

    public void deactivate(ComponentContext context) {
        this.blobProviderDescriptorsRegistry.clear();
        for (BlobProvider blobProvider : this.blobProviders.values()) {
            blobProvider.close();
        }
        this.blobProviders.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint)) {
            if (!(contribution instanceof BlobProviderDescriptor)) {
                throw new NuxeoException("Invalid descriptor: " + contribution.getClass());
            }
        } else {
            throw new NuxeoException("Invalid extension point: " + extensionPoint);
        }
        this.registerBlobProvider((BlobProviderDescriptor)contribution);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint) && contribution instanceof BlobProviderDescriptor) {
            this.unregisterBlobProvider((BlobProviderDescriptor)contribution);
        }
    }

    public void registerBlobProvider(BlobProviderDescriptor descr) {
        this.closeOldBlobProvider(descr.name);
        this.blobProviderDescriptorsRegistry.addContribution(descr);
    }

    public void unregisterBlobProvider(BlobProviderDescriptor descr) {
        this.closeOldBlobProvider(descr.name);
        this.blobProviderDescriptorsRegistry.removeContribution(descr);
    }

    protected synchronized void closeOldBlobProvider(String id) {
        BlobProvider blobProvider = this.blobProviders.remove(id);
        if (blobProvider != null) {
            blobProvider.close();
        }
    }

    @Override
    public synchronized BlobProvider getBlobProvider(String providerId) {
        BlobProvider blobProvider = this.blobProviders.get(providerId);
        if (blobProvider == null) {
            Map<String, String> properties;
            BlobProviderDescriptor descr;
            block9: {
                descr = this.blobProviderDescriptorsRegistry.getBlobProviderDescriptor(providerId);
                if (descr == null) {
                    return null;
                }
                Class<?> klass = descr.klass;
                properties = descr.properties;
                try {
                    if (BlobProvider.class.isAssignableFrom(klass)) {
                        Class<?> blobProviderClass = klass;
                        blobProvider = (BlobProvider)blobProviderClass.newInstance();
                        break block9;
                    }
                    if (BinaryManager.class.isAssignableFrom(klass)) {
                        Class<?> binaryManagerClass = klass;
                        BinaryManager binaryManager = (BinaryManager)binaryManagerClass.newInstance();
                        blobProvider = new BinaryBlobProvider(binaryManager);
                        break block9;
                    }
                    throw new RuntimeException("Unknown class for blob provider: " + klass);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            if (providerId.startsWith(TRANSIENT_ID_PREFIX)) {
                descr.properties.put(TRANSIENT_ID_PREFIX, "true");
            }
            try {
                blobProvider.initialize(providerId, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.blobProviders.put(providerId, blobProvider);
        }
        return blobProvider;
    }

    @Override
    public synchronized BlobProvider getBlobProviderWithNamespace(String providerId, String defaultId) {
        BlobProvider blobProvider = this.getBlobProvider(providerId);
        if (blobProvider != null) {
            return blobProvider;
        }
        BlobProviderDescriptor defaultDescr = this.blobProviderDescriptorsRegistry.getBlobProviderDescriptor(defaultId);
        if (defaultDescr == null) {
            throw new NuxeoException("Missing configuration for blob provider: " + defaultId);
        }
        BlobProviderDescriptor descr = new BlobProviderDescriptor(defaultDescr);
        descr.name = providerId;
        descr.properties.put("namespace", providerId);
        this.registerBlobProvider(descr);
        return this.getBlobProvider(providerId);
    }

    @Override
    public BlobProvider getBlobProvider(Blob blob) {
        if (!(blob instanceof ManagedBlob)) {
            return null;
        }
        ManagedBlob managedBlob = (ManagedBlob)blob;
        return this.getBlobProvider(managedBlob.getProviderId());
    }

    @Override
    @Deprecated
    public InputStream getStream(Blob blob) throws IOException {
        return blob instanceof ManagedBlob ? blob.getStream() : null;
    }

    @Override
    @Deprecated
    public File getFile(Blob blob) {
        return blob instanceof ManagedBlob ? blob.getFile() : null;
    }

    @Override
    public InputStream getThumbnail(Blob blob) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getThumbnail((ManagedBlob)blob);
    }

    @Override
    public URI getURI(Blob blob, BlobManager.UsageHint hint, HttpServletRequest servletRequest) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getURI((ManagedBlob)blob, hint, servletRequest);
    }

    @Override
    public Map<String, URI> getAvailableConversions(Blob blob, BlobManager.UsageHint hint) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return Collections.emptyMap();
        }
        return blobProvider.getAvailableConversions((ManagedBlob)blob, hint);
    }

    @Override
    public synchronized Map<String, BlobProvider> getBlobProviders() {
        Set<String> blobProviderIds = this.blobProviderDescriptorsRegistry.getBlobProviderIds();
        if (this.blobProviders.size() != blobProviderIds.size()) {
            for (String id : blobProviderIds) {
                this.getBlobProvider(id);
            }
        }
        return this.blobProviders;
    }

    protected KeyValueStore getBlobKeyReplacementKeyValuestore() {
        KeyValueService kvService = (KeyValueService)Framework.getService(KeyValueService.class);
        return kvService == null ? null : kvService.getKeyValueStore(BLOB_KEY_REPLACEMENT_KV);
    }

    @Override
    public void setBlobKeyReplacement(String blobProviderId, String key, String newKey) {
        KeyValueStore kvStore = this.getBlobKeyReplacementKeyValuestore();
        if (kvStore == null) {
            return;
        }
        kvStore.put(blobProviderId + ':' + key, newKey, BLOB_KEY_REPLACEMENT_TTL.getSeconds());
    }

    @Override
    public String getBlobKeyReplacement(String blobProviderId, String key) {
        KeyValueStore kvStore = this.getBlobKeyReplacementKeyValuestore();
        if (kvStore == null) {
            return key;
        }
        String newKey = kvStore.getString(blobProviderId + ':' + key);
        return newKey == null ? key : newKey;
    }

    protected KeyValueStore getBlobDeletionKeyValueStore() {
        KeyValueService kvService = (KeyValueService)Framework.getService(KeyValueService.class);
        return kvService == null ? null : kvService.getKeyValueStore(BLOB_DELETION_KV);
    }

    @Override
    public void markBlobForDeletion(String blobProviderId, String key) {
        KeyValueStore kvStore = this.getBlobDeletionKeyValueStore();
        if (kvStore == null) {
            return;
        }
        long now = System.currentTimeMillis();
        kvStore.put(blobProviderId + ':' + key, Long.valueOf(now));
    }

    @Override
    public void deleteBlobsMarkedForDeletion() {
        KeyValueStoreProvider kvStore = (KeyValueStoreProvider)this.getBlobDeletionKeyValueStore();
        if (kvStore == null) {
            return;
        }
        ConfigurationService confService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        Duration delay = confService.getDuration(BLOB_DELETION_DELAY_PROP, BLOB_DELETION_DELAY_DEFAULT);
        long maxTime = Instant.now().minus(delay).toEpochMilli();
        kvStore.keyStream().forEach(k -> {
            Long v = kvStore.getLong(k);
            if (v == null) {
                return;
            }
            if (v > maxTime) {
                log.debug("Blob marked for deletion is not old enough: {}", k);
                return;
            }
            kvStore.put(k, (String)null);
            this.deleteBlob((String)k);
        });
    }

    protected void deleteBlob(String k) {
        int pos = k.indexOf(58);
        if (pos == -1) {
            log.debug("Invalid key for blob marked for deletion: {}", (Object)k);
            return;
        }
        String blobProviderId = k.substring(0, pos);
        String key = k.substring(pos + 1);
        BlobProvider blobProvider = this.getBlobProvider(blobProviderId);
        if (blobProvider == null) {
            log.debug("Unknown blob provider for blob marked for deletion: {}", (Object)k);
            return;
        }
        if (!(blobProvider instanceof BlobStoreBlobProvider)) {
            log.debug("Invalid blob provider class: {} for blob marked for deletion: {}", (Object)blobProvider.getClass().getName(), (Object)k);
            return;
        }
        BlobStore blobStore = ((BlobStoreBlobProvider)blobProvider).store;
        blobStore.deleteBlob(key);
    }

    protected static class BlobProviderDescriptorRegistry
    extends SimpleContributionRegistry<BlobProviderDescriptor> {
        protected BlobProviderDescriptorRegistry() {
        }

        public String getContributionId(BlobProviderDescriptor contrib) {
            return contrib.name;
        }

        public BlobProviderDescriptor clone(BlobProviderDescriptor orig) {
            return new BlobProviderDescriptor(orig);
        }

        public void merge(BlobProviderDescriptor src, BlobProviderDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public BlobProviderDescriptor getBlobProviderDescriptor(String id) {
            return (BlobProviderDescriptor)this.getCurrentContribution(id);
        }

        public Set<String> getBlobProviderIds() {
            return this.currentContribs.keySet();
        }
    }
}

