/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.computation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.BulkServiceImpl;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;

public class BulkStatusComputation
extends AbstractComputation {
    private static final Logger log = LogManager.getLogger(BulkStatusComputation.class);

    public BulkStatusComputation(String name) {
        super(name, 1, 1);
    }

    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        BulkStatus status;
        Codec<BulkStatus> codec = BulkCodecs.getStatusCodec();
        BulkStatus recordStatus = (BulkStatus)codec.decode(record.getData());
        BulkServiceImpl bulkService = (BulkServiceImpl)Framework.getService(BulkService.class);
        if (!recordStatus.isDelta()) {
            status = recordStatus;
        } else {
            status = bulkService.getStatus(recordStatus.getId());
            if (BulkStatus.State.UNKNOWN.equals((Object)status.getState())) {
                log.warn("Skipping status with unknown command: {}, offset: {}.", (Object)recordStatus.getId(), (Object)context.getLastOffset());
                context.askForCheckpoint();
                return;
            }
            status.merge(recordStatus);
        }
        byte[] statusAsBytes = bulkService.setStatus(status);
        if (status.getState() == BulkStatus.State.COMPLETED || recordStatus.getState() == BulkStatus.State.ABORTED) {
            context.produceRecord("o1", status.getId(), statusAsBytes);
            if (status.getTotal() > 50000L) {
                log.warn("BBC: {} for action: {} command completed: {}.", (Object)status.getId(), (Object)status.getAction(), (Object)status);
            }
        }
        context.askForCheckpoint();
    }
}

