/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class BulkCommandJsonWriter
extends ExtensibleEntityJsonWriter<BulkCommand> {
    public BulkCommandJsonWriter() {
        super("bulkCommand", BulkCommand.class);
    }

    protected void writeEntityBody(BulkCommand command, JsonGenerator jg) throws IOException {
        jg.writeStringField("username", command.getUsername());
        jg.writeStringField("repository", command.getRepository());
        jg.writeStringField("query", command.getQuery());
        jg.writeStringField("action", command.getAction());
        jg.writeNumberField("bucket", command.getBucketSize());
        jg.writeNumberField("batch", command.getBatchSize());
        Map<String, Serializable> params = command.getParams();
        if (!params.isEmpty()) {
            jg.writeObjectField("params", params);
        }
    }
}

