/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.io;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.bulk.io.BulkParameters;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class BulkStatusJsonReader
extends EntityJsonReader<BulkStatus> {
    public BulkStatusJsonReader() {
        super("bulkStatus");
    }

    public BulkStatus readEntity(JsonNode jn) {
        Long processingMillis;
        String instantString;
        Long count;
        Long skipCount;
        Long processed;
        String errorMessage;
        String action;
        String id = jn.get("commandId").asText();
        BulkStatus status = new BulkStatus(id);
        String state = this.getStringField(jn, "state");
        if (StringUtils.isNotEmpty((CharSequence)state)) {
            status.setState(BulkStatus.State.valueOf(state));
        }
        if (StringUtils.isNotEmpty((CharSequence)(action = this.getStringField(jn, "action")))) {
            status.setAction(action);
        }
        if (StringUtils.isNotEmpty((CharSequence)(errorMessage = this.getStringField(jn, "errorMessage")))) {
            status.inError(errorMessage);
        }
        if ((processed = this.getLongField(jn, "processed")) != null) {
            status.setProcessed(processed);
        }
        if ((skipCount = this.getLongField(jn, "skipCount")) != null) {
            status.setSkipCount(skipCount);
        }
        if ((count = this.getLongField(jn, "total")) != null) {
            status.setTotal(count);
        }
        if ((count = this.getLongField(jn, "errorCount")) != null) {
            status.setErrorCount(count);
        }
        if (StringUtils.isNotEmpty((CharSequence)(instantString = this.getStringField(jn, "submitted")))) {
            status.setSubmitTime(Instant.parse(instantString));
        }
        if (StringUtils.isNotEmpty((CharSequence)(instantString = this.getStringField(jn, "scrollStart")))) {
            status.setScrollStartTime(Instant.parse(instantString));
        }
        if (StringUtils.isNotEmpty((CharSequence)(instantString = this.getStringField(jn, "scrollEnd")))) {
            status.setScrollEndTime(Instant.parse(instantString));
        }
        if (StringUtils.isNotEmpty((CharSequence)(instantString = this.getStringField(jn, "processingStart")))) {
            status.setProcessingStartTime(Instant.parse(instantString));
        }
        if (StringUtils.isNotEmpty((CharSequence)(instantString = this.getStringField(jn, "processingEnd")))) {
            status.setProcessingEndTime(Instant.parse(instantString));
        }
        if (StringUtils.isNotEmpty((CharSequence)(instantString = this.getStringField(jn, "completed")))) {
            status.setCompletedTime(Instant.parse(instantString));
        }
        if ((processingMillis = this.getLongField(jn, "processingMillis")) != null) {
            status.setProcessingDurationMillis(processingMillis);
        }
        if (StringUtils.isNotEmpty((CharSequence)(instantString = this.getStringField(jn, "username")))) {
            status.setUsername(instantString);
        }
        Map<String, Serializable> result = Collections.emptyMap();
        if (jn.has("result")) {
            result = BulkParameters.paramsToMap(jn.get("result"));
        }
        status.setResult(result);
        return status;
    }
}

