/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scroll;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.core.api.scroll.ScrollRequest;

public class GenericScrollRequest
implements ScrollRequest {
    public static final String SCROLL_TYPE = "generic";
    protected final int size;
    protected final String reference;
    protected final String query;
    protected final String scrollName;
    protected final Map<String, Serializable> options;

    protected GenericScrollRequest(Builder builder) {
        this.query = builder.query;
        this.scrollName = builder.scrollerName;
        this.size = builder.getSize();
        this.options = builder.getOptions();
        this.reference = builder.getReference();
    }

    public String getType() {
        return SCROLL_TYPE;
    }

    public String getName() {
        return this.scrollName;
    }

    public int getSize() {
        return this.size;
    }

    public String getReference() {
        return this.reference;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, Serializable> getOptions() {
        return this.options;
    }

    public static Builder builder(String scrollName, String query) {
        return new Builder(scrollName, query);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        public static final int DEFAULT_SCROLL_SIZE = 10;
        protected final String query;
        protected final String scrollerName;
        protected int size;
        protected String reference;
        protected Map<String, Serializable> options;

        public Builder(String scrollerName, String query) {
            Objects.requireNonNull(scrollerName, "scrollerName cannot be null");
            Objects.requireNonNull(query, "query cannot be null");
            this.scrollerName = scrollerName;
            this.query = query;
        }

        public Builder size(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("size must be > 0");
            }
            this.size = size;
            return this;
        }

        public int getSize() {
            return this.size == 0 ? 10 : this.size;
        }

        public Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public String getReference() {
            return this.reference;
        }

        public Builder options(Map<String, Serializable> options) {
            if (options != null && !options.isEmpty()) {
                if (options.containsKey(null)) {
                    throw new IllegalArgumentException("option key cannot be null");
                }
                this.options = options;
            }
            return this;
        }

        public Map<String, Serializable> getOptions() {
            return this.options == null ? Collections.emptyMap() : this.options;
        }

        public GenericScrollRequest build() {
            return new GenericScrollRequest(this);
        }
    }
}

