/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scroll;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.security.auth.login.LoginException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.scroll.Scroll;
import org.nuxeo.ecm.core.api.scroll.ScrollRequest;
import org.nuxeo.ecm.core.scroll.DocumentScrollRequest;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.NuxeoLoginContext;

public class RepositoryScroll
implements Scroll {
    protected DocumentScrollRequest request;
    protected NuxeoLoginContext loginContext;
    protected CoreSession session;
    protected ScrollResult<String> repoScroller;
    protected Boolean hasNextResult;

    public void init(ScrollRequest request, Map<String, String> options) {
        if (!(request instanceof DocumentScrollRequest)) {
            throw new IllegalArgumentException("Requires a DocumentScrollRequest");
        }
        this.request = (DocumentScrollRequest)request;
        this.login();
        this.openSession();
        this.hasNextResult = null;
    }

    protected void login() {
        String username = this.request.getUsername();
        try {
            this.loginContext = "system".equals(username) ? Framework.loginSystem() : Framework.loginUser((String)username);
        }
        catch (LoginException e) {
            throw new IllegalArgumentException("Cannot login as user: " + username, e);
        }
    }

    protected void openSession() {
        this.session = CoreInstance.getCoreSession((String)this.request.getRepository());
    }

    public boolean hasNext() {
        if (this.hasNextResult == null) {
            this.hasNextResult = this.fetch();
        }
        return this.hasNextResult;
    }

    protected boolean fetch() {
        this.repoScroller = this.repoScroller == null ? this.session.scroll(this.request.getQuery(), this.request.getSize(), (int)this.request.getTimeout().toSeconds()) : this.session.scroll(this.repoScroller.getScrollId());
        return this.repoScroller.hasResults();
    }

    public List<String> next() {
        if (this.hasNextResult == null) {
            this.hasNextResult = this.fetch();
        }
        if (!this.hasNextResult.booleanValue()) {
            throw new NoSuchElementException();
        }
        this.hasNextResult = null;
        return this.repoScroller.getResults();
    }

    public void close() {
        if (this.loginContext != null) {
            this.loginContext.close();
            this.loginContext = null;
        }
    }

    public String toString() {
        return "RepositoryScroll{request=" + this.request + "}";
    }
}

