/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.notification;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class MailBox {
    private static final Log log = LogFactory.getLog(MailBox.class);
    private static final String USER_PREFIX = "user:";
    public String firstname = "";
    public String lastname = "";
    public String address;

    public static List<MailBox> fetchPersonsFromList(List<String> values, boolean isStrict) {
        if (values == null) {
            return new ArrayList<MailBox>();
        }
        ArrayList<MailBox> result = new ArrayList<MailBox>();
        for (String info : values) {
            result.addAll(MailBox.fetchPersonsFromString(info, isStrict));
        }
        return result;
    }

    public static List<MailBox> fetchPersonsFromString(String value, boolean isStrict) {
        ArrayList<MailBox> result = new ArrayList<MailBox>();
        if (isStrict) {
            result.add(new MailBox(value, isStrict));
            return result;
        }
        String[] valuesToResolve = value.split(",");
        UserManager umgr = (UserManager)Framework.getService(UserManager.class);
        for (String info : valuesToResolve) {
            List usernames;
            if (info.startsWith(USER_PREFIX)) {
                result.add(new MailBox(info, isStrict));
                continue;
            }
            if (info.startsWith("group:")) {
                List usernames2 = umgr.getUsersInGroupAndSubGroups(value.substring("group:".length()));
                for (String username : usernames2) {
                    result.add(new MailBox(USER_PREFIX + username, isStrict));
                }
                continue;
            }
            DocumentModel user = umgr.getUserModel(info);
            if (user != null) {
                String address = (String)((Object)user.getPropertyValue("email"));
                String firstname = (String)((Object)user.getPropertyValue("firstName"));
                String lastname = (String)((Object)user.getPropertyValue("lastName"));
                result.add(new MailBox(address, firstname, lastname));
                continue;
            }
            DocumentModel group = umgr.getGroupModel(info);
            if (group != null && (usernames = (List)((Object)group.getPropertyValue(umgr.getGroupMembersField()))) != null) {
                for (String username : usernames) {
                    result.add(new MailBox(USER_PREFIX + username, isStrict));
                }
                continue;
            }
            if (!info.contains("@")) {
                log.warn((Object)("Can't really resolve the mailbox defined, anyway added. Check if something bad configured: " + info));
            }
            result.add(new MailBox(info, null, null));
        }
        return result;
    }

    public MailBox(String address, String firstname, String lastname) {
        this.address = address;
        this.firstname = firstname == null ? "" : firstname;
        this.lastname = lastname == null ? "" : lastname;
    }

    public MailBox(DocumentModel user, boolean isStrict) {
        this.initFromDocumentModel(user);
    }

    public MailBox(String info, boolean isStrict) {
        if (info.startsWith(USER_PREFIX)) {
            String userId = info.substring(USER_PREFIX.length());
            DocumentModel user = this.getUmgr().getUserModel(userId);
            if (user != null) {
                this.initFromDocumentModel(user);
                return;
            }
        }
        if (!isStrict) {
            DocumentModel user = this.getUmgr().getUserModel(info);
            this.initFromDocumentModel(user);
            return;
        }
        if (!info.contains("@")) {
            log.warn((Object)("Info given seems not well formed, please check (sent anyway): " + info));
        }
        this.address = info;
    }

    private void initFromDocumentModel(DocumentModel user) {
        if (user != null && user.getPropertyValue("email") != null && ((String)((Object)user.getPropertyValue("email"))).contains("@")) {
            this.address = (String)((Object)user.getPropertyValue("email"));
        }
        if (user != null && user.getPropertyValue("firstName") != null && !((String)((Object)user.getPropertyValue("firstName"))).isEmpty()) {
            this.firstname = (String)((Object)user.getPropertyValue("firstName"));
        }
        if (user != null && user.getPropertyValue("lastName") != null && !((String)((Object)user.getPropertyValue("lastName"))).isEmpty()) {
            this.firstname = (String)((Object)user.getPropertyValue("lastName"));
        }
    }

    public UserManager getUmgr() {
        return (UserManager)Framework.getService(UserManager.class);
    }

    public String toString() {
        if (!this.firstname.isEmpty() && !this.lastname.isEmpty()) {
            return this.firstname + " " + this.lastname + "<" + this.address + ">";
        }
        return this.address;
    }
}

