/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.PageProviderHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Repository.PageProvider", category="Fetch", label="PageProvider", description="Perform a named provider query on the repository. Result is paginated. The query result will become the input for the next operation.", aliases={"Document.PageProvider"})
public class DocumentPageProviderOperation {
    public static final String ID = "Repository.PageProvider";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;
    @Param(name="providerName", required=true)
    protected String providerName;
    @Param(name="language", required=false, widget="Option", values={"NXQL"})
    protected String lang = "NXQL";
    @Param(name="currentPageIndex", alias={"page"}, required=false)
    protected Integer currentPageIndex;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Param(name="offset", required=false)
    protected Integer offset;
    @Param(name="queryParams", alias={"searchTerm"}, required=false)
    protected StringList strParameters;
    @Param(name="documentLinkBuilder", required=false)
    protected String documentLinkBuilder;
    @Param(name="namedParameters", required=false, description="Named parameters to pass to the page provider to fill in query variables.")
    protected Properties namedParameters;
    @Param(name="sortBy", required=false, description="Sort by properties (separated by comma)")
    protected StringList sortBy;
    @Param(name="sortOrder", required=false, description="Sort order, ASC or DESC", widget="Option", values={"ASC", "DESC"})
    protected StringList sortOrder;
    @Param(name="quickFilters", required=false, description="Quick filter properties (separated by comma)")
    protected StringList quickFilters;
    @Param(name="highlights", required=false, description="Highlight properties (separated by comma)")
    protected StringList highlights;

    @OperationMethod
    public PaginableDocumentModelListImpl run() throws OperationException {
        PaginableDocumentModelListImpl res;
        String skipAggregates;
        ActionContext actionContext;
        int count;
        PageProviderDefinition def = PageProviderHelper.getPageProviderDefinition((String)this.providerName);
        Long targetPage = this.currentPageIndex != null ? Long.valueOf(this.currentPageIndex.longValue()) : null;
        Long targetPageSize = this.pageSize != null ? Long.valueOf(this.pageSize.longValue()) : null;
        Long currentOffset = this.offset != null ? Long.valueOf(this.offset.longValue()) : null;
        Object[] parameters = this.strParameters != null ? this.strParameters.toArray((Object[])new String[0]) : null;
        String ppMethod = Framework.getProperty((String)"org.nuxeo.web.ui.pageprovider.method");
        if (this.strParameters != null && ppMethod != null && "post".equals(ppMethod.toLowerCase()) && (count = StringUtils.countMatches((CharSequence)def.getPattern(), (char)'?')) == 1 && this.strParameters.size() > 1) {
            parameters = new Object[]{String.join((CharSequence)",", (CharSequence[])this.strParameters.toArray((Object[])new String[0]))};
        }
        if ((actionContext = (ActionContext)this.context.get((Object)"seamActionContext")) != null) {
            parameters = PageProviderHelper.resolveELParameters((PageProviderDefinition)def, (Object[])parameters);
        }
        PageProvider pp = PageProviderHelper.getPageProvider((CoreSession)this.session, (PageProviderDefinition)def, (Map)this.namedParameters, (List)this.sortBy, (List)this.sortOrder, (Long)targetPageSize, (Long)targetPage, (Long)currentOffset, (List)this.highlights, (List)this.quickFilters, (Object[])parameters);
        HttpServletRequest request = (HttpServletRequest)this.context.get((Object)"request");
        if (request != null && (skipAggregates = request.getHeader("skipAggregates")) != null) {
            Map props = pp.getProperties();
            props.put("skipAggregates", Boolean.parseBoolean(request.getHeader("skipAggregates")));
            pp.setProperties(props);
        }
        if ((res = new PaginableDocumentModelListImpl(pp, this.documentLinkBuilder)).hasError()) {
            throw new OperationException(res.getErrorMessage());
        }
        return res;
    }
}

