/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.bulk;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractAutomationBulkAction
implements StreamProcessorTopology {
    private static final Logger log = LogManager.getLogger(AbstractAutomationBulkAction.class);
    public static final String FAIL_ON_ERROR_OPTION = "failOnError";
    public static final String OPERATION_ID = "operationId";
    public static final String OPERATION_PARAMETERS = "parameters";

    protected abstract String getActionName();

    protected String getActionFullName() {
        return "bulk/" + this.getActionName();
    }

    public Topology getTopology(Map<String, String> options) {
        boolean failOnError = BooleanUtils.toBoolean((String)options.get(FAIL_ON_ERROR_OPTION));
        return Topology.builder().addComputation(() -> new AutomationComputation(this.getActionFullName(), failOnError), Arrays.asList("i1:" + this.getActionFullName(), "o1:bulk/status")).build();
    }

    public static class AutomationComputation
    extends AbstractBulkComputation {
        public static final String DOC_INPUT_TYPE = "document";
        public static final String DOCS_INPUT_TYPE = "documents";
        protected final boolean failOnError;
        protected AutomationService service;
        protected String operationId;
        protected String inputType;
        protected Map<String, ?> params;

        public AutomationComputation(String name, boolean failOnError) {
            super(name);
            this.failOnError = failOnError;
        }

        public void startBucket(String bucketKey) {
            this.operationId = null;
            this.service = (AutomationService)Framework.getService(AutomationService.class);
            Map commandParams = this.getCurrentCommand().getParams();
            this.checkOperation((String)commandParams.get(AbstractAutomationBulkAction.OPERATION_ID));
            this.checkParams((Serializable)commandParams.get(AbstractAutomationBulkAction.OPERATION_PARAMETERS));
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            if (this.operationId == null) {
                return;
            }
            DocumentModelList documents = this.loadDocuments(session, ids);
            if (DOCS_INPUT_TYPE.equals(this.inputType)) {
                this.runOperationOnAllDocuments(session, documents);
            } else {
                this.runOperationOnEachDocument(session, documents);
            }
        }

        protected void runOperationOnAllDocuments(CoreSession session, DocumentModelList documents) {
            try (OperationContext ctx = new OperationContext(session).handleTransaction(false);){
                ctx.setInput((Object)documents);
                this.service.run(ctx, this.operationId, this.params);
                session.save();
            }
            catch (OperationException e) {
                this.handleError((List<DocumentModel>)documents, (Exception)((Object)e));
            }
        }

        protected void runOperationOnEachDocument(CoreSession session, DocumentModelList documents) {
            for (DocumentModel doc : documents) {
                try {
                    OperationContext ctx = new OperationContext(session).handleTransaction(false);
                    try {
                        ctx.setInput((Object)doc);
                        this.service.run(ctx, this.operationId, this.params);
                    }
                    finally {
                        if (ctx == null) continue;
                        ctx.close();
                    }
                }
                catch (OperationException | NuxeoException e) {
                    this.handleError(List.of(doc), (Exception)e);
                }
            }
            session.save();
        }

        protected void handleError(List<DocumentModel> documents, Exception e) {
            String documentIds = documents.stream().map(DocumentModel::getId).collect(Collectors.joining(",", "[", "]"));
            String message = String.format("Bulk Action Operation with commandId: %s fails on documents: %s", this.command.getId(), documentIds);
            if (this.failOnError) {
                TransactionHelper.setTransactionRollbackOnly();
                throw new NuxeoException(message, (Throwable)e);
            }
            this.delta.inError((long)documents.size(), message);
            log.warn(message, (Throwable)e);
        }

        protected void checkOperation(String operationId) {
            block5: {
                if (StringUtils.isBlank((CharSequence)operationId)) {
                    log.warn("No operationId provided skipping command: {}", (Object)this.getCurrentCommand().getId());
                    return;
                }
                try {
                    OperationType op = this.service.getOperation(operationId);
                    this.inputType = op.getInputType();
                    if (this.inputType == null || DOC_INPUT_TYPE.equals(this.inputType)) {
                        this.inputType = DOC_INPUT_TYPE;
                        break block5;
                    }
                    if (DOCS_INPUT_TYPE.equals(this.inputType)) {
                        this.inputType = DOCS_INPUT_TYPE;
                        break block5;
                    }
                    log.warn("Unsupported operation input type: {} for command: {}", (Object)this.inputType, (Object)this.getCurrentCommand().getId());
                    return;
                }
                catch (OperationNotFoundException e) {
                    log.warn("Operation: '{}' not found, skipping command: {}", (Object)operationId, (Object)this.getCurrentCommand().getId());
                    return;
                }
            }
            this.operationId = operationId;
        }

        protected void checkParams(Serializable serializable) {
            if (serializable == null) {
                this.params = null;
            } else if (serializable instanceof HashMap) {
                this.params = (Map)((Object)serializable);
            } else {
                log.warn("Unknown operation parameters type: {} for command: {}", serializable.getClass(), (Object)this.command);
                this.operationId = null;
            }
        }
    }
}

