/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.bulk;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.bulk.AutomationBulkActionUi;
import org.nuxeo.ecm.automation.core.util.PageProviderHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.bulk.BulkAdminService;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.io.BulkParameters;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Bulk.RunAction", category="Services", label="Run a bulk command", addToStudio=true, description="Run a bulk action on a set of documents expressed by a NXQL.")
public class BulkRunAction {
    private static final Logger log = LogManager.getLogger(BulkRunAction.class);
    public static final String ID = "Bulk.RunAction";
    protected static final String WHERE_TOKEN = " WHERE ";
    protected static final String ORDER_TOKEN = " ORDER BY ";
    @Context
    protected BulkService service;
    @Context
    protected BulkAdminService admin;
    @Context
    protected CoreSession session;
    @Param(name="query", required=false)
    protected String query;
    @Param(name="providerName", required=false)
    protected String providerName;
    @Param(name="queryParams", required=false)
    protected StringList queryParams;
    @Param(name="namedParameters", required=false, description="Named parameters to pass to the page provider to fill in query variables.")
    protected Properties namedParameters;
    @Param(name="quickFilters", required=false, description="Quick filter properties (separated by comma)")
    protected StringList quickFilters;
    @Param(name="action", required=true)
    protected String action;
    @Param(name="repositoryName", required=false)
    protected String repositoryName;
    @Param(name="bucketSize", required=false)
    protected int bucketSize;
    @Param(name="batchSize", required=false)
    protected int batchSize;
    @Param(name="parameters", required=false)
    protected String parametersAsJson;
    @Param(name="excludeDocs", required=false)
    protected StringList excludeDocs;
    @Param(name="queryLimit", required=false)
    protected long queryLimit;

    @OperationMethod(asyncService=BulkService.class)
    public BulkStatus run() throws IOException, OperationException {
        String commandId;
        String operationId;
        int limit;
        PageProviderDefinition def;
        log.error("Bulk action info: action={}, query={}, provider={}, params={}", (Object)this.action, (Object)this.query, (Object)this.providerName, (Object)this.queryParams);
        if (!this.admin.getActions().contains(this.action)) {
            throw new NuxeoException("Action '" + this.action + "' not found", 404);
        }
        if (!this.admin.isHttpEnabled(this.action) && !this.session.getPrincipal().isAdministrator()) {
            throw new NuxeoException("Action '" + this.action + "' denied", 403);
        }
        if (this.query == null && this.providerName == null) {
            throw new NuxeoException("Query and ProviderName cannot be both null", 400);
        }
        PageProviderDefinition pageProviderDefinition = def = this.query != null ? PageProviderHelper.getQueryPageProviderDefinition((String)this.query) : PageProviderHelper.getPageProviderDefinition((String)this.providerName);
        if (def == null) {
            throw new NuxeoException("Could not get Provider Definition from either query or provider name", 400);
        }
        PageProvider provider = PageProviderHelper.getPageProvider((CoreSession)this.session, (PageProviderDefinition)def, (Map)this.namedParameters, null, null, null, null, null, (List)this.quickFilters, this.queryParams != null ? this.queryParams.toArray((Object[])new String[0]) : null);
        this.query = PageProviderHelper.buildQueryStringWithAggregates((PageProvider)provider);
        if (this.query.contains("?")) {
            throw new NuxeoException("Query parameters could not be parsed", 400);
        }
        if (this.excludeDocs != null && !this.excludeDocs.isEmpty()) {
            this.query = this.addExcludeClause(this.query, this.excludeDocs);
        }
        String scroller = ((PageProviderService)Framework.getService(PageProviderService.class)).getPageProviderType(provider).toString();
        BulkCommand.Builder builder = new BulkCommand.Builder(this.action, this.query, this.session.getPrincipal().getName()).scroller(scroller);
        Map<String, Serializable> params = this.getParams(this.parametersAsJson);
        builder.params(params);
        if (this.repositoryName != null) {
            builder.repository(this.repositoryName);
        } else {
            builder.repository(this.session.getRepositoryName());
        }
        if (this.bucketSize > 0) {
            builder.bucket(this.bucketSize);
        }
        if (this.batchSize > 0) {
            builder.batch(this.batchSize);
        }
        if (this.queryLimit > 0L) {
            builder.queryLimit(this.queryLimit);
        } else if ("automationUi".equals(this.action) && params.containsKey("operationId") && (limit = AutomationBulkActionUi.getQueryLimit(operationId = (String)((Object)params.get("operationId")))) > 0) {
            log.debug("Set queryLimit to: {} for {} operationId: {}", (Object)limit, (Object)"automationUi", (Object)operationId);
            builder.queryLimit((long)limit);
        }
        try {
            BulkCommand command = builder.build();
            log.debug("Submitting Bulk Command: {}", (Object)command);
            commandId = this.service.submit(command);
        }
        catch (IllegalArgumentException e) {
            throw new NuxeoException(e.getMessage(), (Throwable)e, 400);
        }
        BulkStatus status = (BulkStatus)this.service.getStatus((Serializable)((Object)commandId));
        log.debug("Status: {}", (Object)status);
        return status;
    }

    protected Map<String, Serializable> getParams(String parametersAsJson) {
        try {
            return BulkParameters.paramsToMap((String)parametersAsJson);
        }
        catch (IOException e) {
            throw new NuxeoException("Could not parse parameters, expecting valid json value", (Throwable)e, 400);
        }
    }

    protected String addExcludeClause(String query, StringList excludeDocs) {
        int wherePos;
        log.debug("Excluding doc ids: {} from query: {}", (Object)excludeDocs, query);
        String ids = excludeDocs.stream().map(NXQL::escapeString).collect(Collectors.joining(","));
        String upperQuery = ((String)query).toUpperCase();
        String order = "";
        int orderByPos = upperQuery.lastIndexOf(ORDER_TOKEN);
        if (orderByPos > 0) {
            order = ((String)query).substring(orderByPos);
            query = ((String)query).substring(0, orderByPos);
        }
        query = (wherePos = upperQuery.indexOf(WHERE_TOKEN)) > 0 ? ((String)query).substring(0, wherePos) + " WHERE (" + ((String)query).substring(wherePos + 7) + ") AND " : (String)query + WHERE_TOKEN;
        query = (String)query + "ecm:uuid NOT IN (" + ids + ")";
        query = (String)query + order;
        log.debug("Query rewritten: {}", query);
        return query;
    }
}

