/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.directory;

import java.io.IOException;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.features.SuggestConstants;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Directory.SuggestEntries", category="Services", label="Get suggested directory entries", description="Get the entries suggestions of a directory. This is returning a blob containing a serialized JSON array. Prefix parameter is used to filter the entries.", addToStudio=false)
public class SuggestDirectoryEntries {
    Collator collator;
    private static final Logger log = LogManager.getLogger(SuggestDirectoryEntries.class);
    public static final String ID = "Directory.SuggestEntries";
    @Context
    protected OperationContext ctx;
    @Context
    protected DirectoryService directoryService;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="directoryName", required=true)
    protected String directoryName;
    @Param(name="localize", required=false)
    protected boolean localize;
    @Param(name="lang", required=false)
    protected String lang;
    @Param(name="searchTerm", alias={"prefix"}, required=false)
    protected String prefix;
    @Param(name="labelFieldName", required=false)
    protected String labelFieldName = "label";
    @Param(name="dbl10n", required=false)
    protected boolean dbl10n = false;
    @Param(name="canSelectParent", required=false)
    protected boolean canSelectParent = false;
    @Param(name="filterParent", required=false)
    protected boolean filterParent = false;
    @Param(name="keySeparator", required=false)
    protected String keySeparator = "/";
    @Param(name="displayObsoleteEntries", required=false)
    protected boolean displayObsoleteEntries = false;
    @Param(name="filters", required=false)
    protected Properties filters = new Properties();
    @Param(name="limit", required=false)
    protected int limit = -1;
    @Param(name="contains", required=false)
    protected boolean contains = false;
    @Param(name="caseSensitive", required=false)
    protected boolean caseSensitive = false;
    @Param(name="absoluteLabelSeparator", required=false)
    protected String absoluteLabelSeparator = "/";
    private String label = null;
    private String obsoleteWarningMessage = null;

    protected String getLang() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
            if (this.lang == null) {
                this.lang = "en";
            }
        }
        return this.lang;
    }

    protected Locale getLocale() {
        return new Locale(this.getLang());
    }

    protected Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.getLocale());
            if (this.caseSensitive) {
                this.collator.setStrength(2);
            } else {
                this.collator.setStrength(1);
            }
        }
        return this.collator;
    }

    protected String getObsoleteWarningMessage() {
        if (this.obsoleteWarningMessage == null) {
            this.obsoleteWarningMessage = I18NUtils.getMessageString((String)"messages", (String)"obsolete", (Object[])new Object[0], (Locale)this.getLocale());
        }
        return this.obsoleteWarningMessage;
    }

    @OperationMethod
    public Blob run() throws IOException {
        Directory directory = this.directoryService.getDirectory(this.directoryName);
        if (directory == null) {
            log.error("Could not find directory with name: {}", (Object)this.directoryName);
            return null;
        }
        try (Session session = directory.getSession();){
            Schema schema = this.schemaManager.getSchema(directory.getSchema());
            this.label = SuggestConstants.getLabelFieldName(schema, this.dbl10n, this.labelFieldName, this.getLang());
            HashMap<String, Object> filter = new HashMap<String, Object>((Map<String, Object>)this.filters);
            if (!this.displayObsoleteEntries && !this.canSelectParent) {
                filter.put("obsolete", 0L);
            }
            boolean postFilter = true;
            TreeSet<String> fullText = new TreeSet<String>();
            if (this.dbl10n || !this.localize) {
                postFilter = false;
                if (this.prefix != null && !this.prefix.isEmpty()) {
                    Object computedPrefix = this.prefix;
                    if (this.contains) {
                        computedPrefix = "%" + (String)computedPrefix;
                    }
                    filter.put(this.label, computedPrefix);
                    fullText.add(this.label);
                }
            }
            DocumentModelList entries = session.query(filter, fullText, Collections.emptyMap(), false, postFilter ? -1 : this.limit, -1);
            boolean isChained = this.isChainedDirectory(directory);
            boolean hasParentDirectory = this.hasParentDirectory(directory.getParentDirectory(), this.directoryName);
            boolean pFilter = postFilter;
            JSONAdapter jsonAdapter = new JSONAdapter(directory);
            entries.stream().map(entry -> new JSONAdapter(directory, (DocumentModel)entry)).filter(adapter -> this.filterJSONAdapter((JSONAdapter)adapter, isChained, hasParentDirectory, pFilter)).forEach(jsonAdapter::push);
            Blob blob = Blobs.createJSONBlobFromValue(jsonAdapter.getChildrenJSONArray());
            return blob;
        }
    }

    private boolean filterJSONAdapter(JSONAdapter adapter, boolean isChained, boolean hasParentDirectory, boolean postFilter) {
        if (!this.filterParent && isChained && !hasParentDirectory && !adapter.isLeaf()) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.prefix) && postFilter) {
            if (this.contains) {
                return adapter.getLabel().toLowerCase().contains(this.prefix.toLowerCase());
            }
            return adapter.getLabel().toLowerCase().startsWith(this.prefix.toLowerCase());
        }
        return true;
    }

    protected String translate(String key) {
        if (key == null) {
            return "";
        }
        return I18NUtils.getMessageString((String)"messages", (String)key, (Object[])new Object[0], (Locale)this.getLocale());
    }

    private boolean isChainedDirectory(Directory directory) {
        String schemaName = directory.getSchema();
        Schema schema = this.schemaManager.getSchema(schemaName);
        Field parentField = schema.getField("parent");
        return parentField != null;
    }

    private boolean hasParentDirectory(String parentDirectoryName, String directoryName) {
        return StringUtils.isNotBlank((CharSequence)parentDirectoryName) && !parentDirectoryName.equals(directoryName);
    }

    private class JSONAdapter
    implements Comparable<JSONAdapter> {
        private final Map<String, JSONAdapter> children;
        private final Directory directory;
        private boolean isRoot;
        private Boolean isLeaf = null;
        private final boolean isChained;
        private final String parentDirectoryName;
        private final boolean hasParentDirectory;
        private Map<String, Object> obj;

        public JSONAdapter(Directory directory) {
            this.directory = directory;
            this.parentDirectoryName = directory.getParentDirectory();
            this.hasParentDirectory = SuggestDirectoryEntries.this.hasParentDirectory(this.parentDirectoryName, directory.getName());
            this.isChained = SuggestDirectoryEntries.this.isChainedDirectory(directory);
            this.children = new HashMap<String, JSONAdapter>();
            this.isRoot = true;
        }

        public JSONAdapter(Directory directory, DocumentModel entry) {
            this(directory);
            this.isRoot = false;
            this.obj = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Serializable> properties = new LinkedHashMap<String, Serializable>();
            for (Map.Entry e : directory.getSchemaFieldMap().entrySet()) {
                String key = (String)e.getKey();
                Field field = (Field)e.getValue();
                Object value = entry.getPropertyValue(field.getName().getPrefixedName());
                if (value == null) continue;
                if (suggestDirectoryEntries.label.equals(key)) {
                    if (suggestDirectoryEntries.localize && !suggestDirectoryEntries.dbl10n) {
                        value = suggestDirectoryEntries.translate(value.toString());
                    }
                    this.obj.put("displayLabel", value);
                }
                this.obj.put(key, value);
                properties.put(key, (Serializable)value);
            }
            if (suggestDirectoryEntries.displayObsoleteEntries && this.isObsolete()) {
                this.obj.put("warn_message", suggestDirectoryEntries.getObsoleteWarningMessage());
            }
            this.obj.put("directoryName", directory.getName());
            this.obj.put("properties", properties);
            this.obj.put("entity-type", "directoryEntry");
        }

        @Override
        public int compareTo(JSONAdapter other) {
            if (other != null) {
                int i = this.getOrder() - other.getOrder();
                if (i != 0) {
                    return i;
                }
                return SuggestDirectoryEntries.this.getCollator().compare(this.getLabel(), other.getLabel());
            }
            return -1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JSONAdapter other = (JSONAdapter)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.obj == null ? other.obj != null : !this.obj.equals(other.obj));
        }

        public List<Map<String, Object>> getChildrenJSONArray() {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (JSONAdapter ja : this.getSortedChildren()) {
                ja.getObj().put("computedId", (String)(!this.isRoot ? this.getComputedId() + SuggestDirectoryEntries.this.keySeparator : "") + ja.getId());
                ja.getObj().put("absoluteLabel", (String)(!this.isRoot ? this.getAbsoluteLabel() + SuggestDirectoryEntries.this.absoluteLabelSeparator : "") + ja.getLabel());
                result.add(ja.toJSONObject());
            }
            return result;
        }

        public String getComputedId() {
            return this.isRoot ? null : this.obj.getOrDefault("computedId", "").toString();
        }

        public String getId() {
            return this.isRoot ? null : this.obj.getOrDefault("id", "").toString();
        }

        public String getLabel() {
            return this.isRoot ? null : this.obj.getOrDefault("displayLabel", "").toString();
        }

        public String getAbsoluteLabel() {
            return this.isRoot ? null : this.obj.getOrDefault("absoluteLabel", "").toString();
        }

        public boolean isObsolete() {
            return Integer.parseInt(this.obj.getOrDefault("obsolete", "0").toString()) > 0;
        }

        public Map<String, Object> getObj() {
            return this.obj;
        }

        public int getOrder() {
            return this.isRoot ? -1 : Integer.parseInt(this.obj.getOrDefault("ordering", "0").toString());
        }

        private SuggestDirectoryEntries getOuterType() {
            return SuggestDirectoryEntries.this;
        }

        public String getParentId() {
            return this.isRoot ? null : this.obj.getOrDefault("parent", "").toString();
        }

        public List<JSONAdapter> getSortedChildren() {
            if (this.children == null) {
                return List.of();
            }
            ArrayList<JSONAdapter> result = new ArrayList<JSONAdapter>(this.children.values());
            Collections.sort(result);
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.obj == null ? 0 : this.obj.hashCode());
            return result;
        }

        public boolean isLeaf() {
            if (this.isLeaf == null) {
                if (this.isChained && !this.hasParentDirectory) {
                    String id = this.getId();
                    if (id != null) {
                        Map<String, String> filter = Collections.singletonMap("parent", this.getId());
                        try (Session s = this.directory.getSession();){
                            this.isLeaf = s.query(filter, Collections.emptySet(), Collections.emptyMap(), false, 1, -1).isEmpty();
                        }
                        catch (DirectoryException ce) {
                            log.error("Could not retrieve children of entry", (Throwable)ce);
                            this.isLeaf = true;
                        }
                    } else {
                        this.isLeaf = true;
                    }
                } else {
                    this.isLeaf = this.children.isEmpty();
                }
            }
            return this.isLeaf;
        }

        private void mergeJsonAdapter(JSONAdapter branch) {
            if (SuggestDirectoryEntries.this.canSelectParent && !SuggestDirectoryEntries.this.displayObsoleteEntries && branch.isObsolete()) {
                log.debug("Skip obsolete {}", (Object)branch.getId());
                return;
            }
            JSONAdapter found = this.children.get(branch.getId());
            if (found != null) {
                for (JSONAdapter branchChild : branch.children.values()) {
                    found.mergeJsonAdapter(branchChild);
                }
            } else {
                this.children.put(branch.getId(), branch);
            }
        }

        public JSONAdapter push(JSONAdapter newEntry) {
            String parentIdOfNewEntry = newEntry.getParentId();
            if (parentIdOfNewEntry != null && !parentIdOfNewEntry.isEmpty()) {
                if (parentIdOfNewEntry.equals(this.getId()) && (!newEntry.hasParentDirectory || newEntry.parentDirectoryName.equals(this.directory.getName()))) {
                    this.mergeJsonAdapter(newEntry);
                    return this;
                }
                JSONAdapter parentAdapter = this.getParentAdapter(newEntry);
                if (parentAdapter == null) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = newEntry::getParentId;
                    supplierArray[1] = newEntry::getId;
                    log.info("parent: {} not found for entry: {}", supplierArray);
                    this.mergeJsonAdapter(newEntry);
                    return this;
                }
                return this.push(parentAdapter.push(newEntry));
            }
            this.mergeJsonAdapter(newEntry);
            return this;
        }

        private JSONAdapter getParentAdapter(JSONAdapter entry) {
            String parentId = entry.getParentId();
            Directory d = entry.hasParentDirectory ? ((DirectoryService)Framework.getService(DirectoryService.class)).getDirectory(entry.parentDirectoryName) : entry.directory;
            try (Session session = d.getSession();){
                DocumentModel parent = session.getEntry(parentId);
                JSONAdapter jSONAdapter = parent != null ? new JSONAdapter(d, parent) : null;
                return jSONAdapter;
            }
        }

        private Map<String, Object> toJSONObject() {
            if (this.isLeaf()) {
                return this.getObj();
            }
            if (SuggestDirectoryEntries.this.canSelectParent) {
                Map<String, Object> o = this.getObj();
                o.put("children", this.getChildrenJSONArray());
                return o;
            }
            LinkedHashMap<String, Object> o = new LinkedHashMap<String, Object>();
            o.put("displayLabel", this.getLabel());
            o.put("children", this.getChildrenJSONArray());
            return o;
        }

        public String toString() {
            return String.valueOf(this.obj);
        }
    }
}

