/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.features;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class SuggestConstants {
    private static final Log log = LogFactory.getLog(SuggestConstants.class);
    public static final String LANG_TOKEN = "{lang}";
    private static final String FORCE_DISPLAY_EMAIL_IN_SUGGESTION = "nuxeo.ui.displayEmailInUserSuggestion";
    public static final String ID = "id";
    public static final String LABEL = "displayLabel";
    public static final String ICON = "icon";
    public static final String DEFAULT_LANG = "en";
    public static final String USER_TYPE = "USER_TYPE";
    public static final String GROUP_TYPE = "GROUP_TYPE";
    public static final String TYPE_KEY_NAME = "type";
    public static final String PREFIXED_ID_KEY_NAME = "prefixed_id";
    protected static Boolean forceDisplayEmailInSuggestion = null;
    public static final String DISPLAY_ICON = "displayIcon";
    public static final String PARENT_FIELD_ID = "parent";
    public static final String OBSOLETE_FIELD_ID = "obsolete";
    public static final String ABSOLUTE_LABEL = "absoluteLabel";
    public static final String COMPUTED_ID = "computedId";
    public static final String WARN_MESSAGE_LABEL = "warn_message";
    public static final String DIRECTORY_ORDER_FIELD_NAME = "ordering";
    public static final String DIRECTORY_DEFAULT_LABEL_COL_NAME = "label";
    public static final String DEFAULT_KEY_SEPARATOR = "/";

    public static void computeGroupLabel(Map<String, Object> obj, String groupId, String groupLabelField, boolean hideFirstLabel) {
        String groupLabelValue;
        String label = null;
        label = hideFirstLabel ? groupId : (StringUtils.isNotBlank((CharSequence)(groupLabelValue = (String)obj.get(groupLabelField))) ? groupLabelValue : groupId);
        obj.put(LABEL, label);
    }

    public static void computeUserGroupIcon(Map<String, Object> obj, boolean hideIcon) {
        if (obj != null && !hideIcon) {
            String userGroupType = (String)obj.get(TYPE_KEY_NAME);
            obj.put(DISPLAY_ICON, StringUtils.isNotBlank((CharSequence)userGroupType) && (userGroupType.equals(USER_TYPE) || userGroupType.equals(GROUP_TYPE)));
        }
    }

    public static void computeUserLabel(Map<String, Object> obj, String firstLabelField, String secondLabelField, String thirdLabelField, boolean hideFirstLabel, boolean hideSecondLabel, boolean hideThirdLabel, boolean displayEmailInSuggestion, String userId) {
        Object result = "";
        if (obj != null) {
            String lastname;
            if (StringUtils.isNotBlank((CharSequence)firstLabelField) && !hideFirstLabel) {
                String firstLabel = (String)obj.get(firstLabelField);
                result = (String)result + (StringUtils.isNotBlank((CharSequence)firstLabel) ? firstLabel : "");
            } else if (!hideFirstLabel) {
                String firstname = (String)obj.get("firstName");
                result = (String)result + (StringUtils.isNotBlank((CharSequence)firstname) ? firstname : "");
            }
            if (StringUtils.isNotBlank((CharSequence)secondLabelField) && !hideSecondLabel) {
                String secondLabel = (String)obj.get(firstLabelField);
                if (StringUtils.isNotBlank((CharSequence)secondLabel)) {
                    if (StringUtils.isNotBlank((CharSequence)result)) {
                        result = (String)result + " ";
                    }
                    result = (String)result + secondLabel;
                }
            } else if (!hideSecondLabel && StringUtils.isNotBlank((CharSequence)(lastname = (String)obj.get("lastName")))) {
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    result = (String)result + " ";
                }
                result = (String)result + lastname;
            }
            if (StringUtils.isBlank((CharSequence)result)) {
                result = (String)result + (StringUtils.isNotBlank((CharSequence)userId) ? userId : "");
            }
            if (SuggestConstants.isForceDisplayEmailInSuggestion() || displayEmailInSuggestion && !hideThirdLabel) {
                if (StringUtils.isNotBlank((CharSequence)thirdLabelField)) {
                    String thirdLabel = (String)obj.get(thirdLabelField);
                    if (StringUtils.isNotBlank((CharSequence)thirdLabel)) {
                        if (StringUtils.isNotBlank((CharSequence)result)) {
                            result = (String)result + " ";
                        }
                        result = (String)result + thirdLabel;
                    }
                } else {
                    String email = (String)obj.get("email");
                    if (StringUtils.isNotBlank((CharSequence)email)) {
                        if (StringUtils.isNotBlank((CharSequence)result)) {
                            result = (String)result + " ";
                        }
                        result = (String)result + email;
                    }
                }
            }
            obj.put(LABEL, result);
        }
    }

    public static String getLabelFieldName(Schema schema, boolean dbl10n, String labelFieldName, String lang) {
        if (labelFieldName == null || labelFieldName.isEmpty()) {
            labelFieldName = DIRECTORY_DEFAULT_LABEL_COL_NAME;
        }
        if (dbl10n) {
            int i = labelFieldName.indexOf(LANG_TOKEN);
            if (i >= 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(labelFieldName.substring(0, i));
                sb.append(lang);
                sb.append(labelFieldName.substring(i + LANG_TOKEN.length()));
                String result = sb.toString();
                if (schema.getField(result) != null) {
                    return result;
                }
                sb = new StringBuilder();
                sb.append(labelFieldName.substring(0, i));
                sb.append(DEFAULT_LANG);
                sb.append(labelFieldName.substring(i + LANG_TOKEN.length()));
                return sb.toString();
            }
            Object result = labelFieldName + "_" + lang;
            if (schema.getField((String)result) != null) {
                return result;
            }
            log.warn((Object)String.format("Unable to find field %s in directory schema %s. Trying to fallback on default one.", labelFieldName, schema.getName()));
            result = "label_en";
            if (schema.getField((String)result) != null) {
                return result;
            }
            result = DIRECTORY_DEFAULT_LABEL_COL_NAME;
            if (schema.getField((String)result) != null) {
                return result;
            }
            if (schema.getField(labelFieldName) != null) {
                return labelFieldName;
            }
            throw new IllegalArgumentException(String.format("Unable to find field %s in directory schema %s", labelFieldName, schema.getName()));
        }
        if (schema.getField(labelFieldName) != null) {
            return labelFieldName;
        }
        throw new IllegalArgumentException(String.format("Unable to find field %s in directory schema %s", labelFieldName, schema.getName()));
    }

    protected static boolean isForceDisplayEmailInSuggestion() {
        if (forceDisplayEmailInSuggestion == null) {
            ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
            forceDisplayEmailInSuggestion = cs.isBooleanTrue(FORCE_DISPLAY_EMAIL_IN_SUGGESTION);
        }
        return forceDisplayEmailInSuggestion;
    }

    protected SuggestConstants() {
    }
}

