/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.action;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.validation.DocumentValidationException;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class SetPropertiesAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "setProperties";
    public static final String ACTION_FULL_NAME = "bulk/setProperties";
    public static final String PARAM_DISABLE_AUDIT = "disableAuditLogger";
    public static final String PARAM_VERSIONING_OPTION = "VersioningOption";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(SetPropertyComputation::new, Arrays.asList("i1:bulk/setProperties", "o1:bulk/status")).build();
    }

    public static class SetPropertyComputation
    extends AbstractBulkComputation {
        private static final Logger log = LogManager.getLogger(SetPropertyComputation.class);
        protected boolean disableVersioning;
        protected boolean disableAudit;

        public SetPropertyComputation() {
            super(SetPropertiesAction.ACTION_FULL_NAME);
        }

        @Override
        public void startBucket(String bucketKey) {
            BulkCommand command = this.getCurrentCommand();
            Serializable auditParam = (Serializable)command.getParam(SetPropertiesAction.PARAM_DISABLE_AUDIT);
            this.disableAudit = auditParam != null && Boolean.parseBoolean(auditParam.toString());
            Serializable versioningParam = (Serializable)command.getParam(SetPropertiesAction.PARAM_VERSIONING_OPTION);
            this.disableVersioning = VersioningOption.NONE.toString().equals(versioningParam);
        }

        @Override
        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            long errorCount = 0L;
            for (DocumentModel doc : this.loadDocuments(session, ids)) {
                if (this.disableAudit) {
                    doc.putContextData(SetPropertiesAction.PARAM_DISABLE_AUDIT, (Serializable)Boolean.TRUE);
                }
                if (this.disableVersioning) {
                    doc.putContextData("DisableAutomaticVersioning", (Serializable)Boolean.TRUE);
                    doc.putContextData(SetPropertiesAction.PARAM_VERSIONING_OPTION, (Serializable)VersioningOption.NONE);
                }
                boolean updated = false;
                for (Map.Entry<String, Serializable> es : properties.entrySet()) {
                    if (SetPropertiesAction.PARAM_DISABLE_AUDIT.equals(es.getKey()) || SetPropertiesAction.PARAM_VERSIONING_OPTION.equals(es.getKey())) continue;
                    try {
                        doc.setPropertyValue(es.getKey(), es.getValue());
                        updated = true;
                    }
                    catch (PropertyException e) {
                        log.warn("Cannot write property: {} of document: {}", (Object)es.getKey(), (Object)doc.getId(), (Object)e);
                        this.delta.inError(0L, String.format("Cannot set property: %s of document: %s, %s", es.getKey(), doc.getId(), e.getMessage()), 0);
                    }
                }
                if (!updated) {
                    ++errorCount;
                    continue;
                }
                try {
                    session.saveDocument(doc);
                }
                catch (PropertyException | DocumentValidationException e) {
                    log.warn("Cannot save document: {}", (Object)doc.getId(), (Object)e);
                    this.delta.inError(0L, String.format("Cannot save document: %s, %s", doc.getId(), e.getMessage()), 0);
                    ++errorCount;
                }
            }
            this.delta.setErrorCount(errorCount);
        }
    }
}

