/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.OutputCollector;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.impl.InvokableIteratorMethod;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;

public class OperationTypeImpl
implements OperationType {
    protected AutomationService service;
    protected String id;
    protected String[] aliases;
    protected Class<?> type;
    protected Map<String, Field> params;
    protected List<InvokableMethod> methods;
    protected List<Field> injectableFields;
    protected String inputType;
    protected String contributingComponent;
    protected List<WidgetDefinition> widgetDefinitionList;
    protected boolean enabled = true;

    public OperationTypeImpl(AutomationService service, Class<?> type) {
        this(service, type, null);
    }

    public OperationTypeImpl(AutomationService service, Class<?> type, String contributingComponent) {
        this(service, type, contributingComponent, null);
    }

    public OperationTypeImpl(AutomationService service, Class<?> type, String contributingComponent, List<WidgetDefinition> widgetDefinitionList) {
        Operation anno = type.getAnnotation(Operation.class);
        if (anno == null) {
            throw new IllegalArgumentException("Invalid operation class: " + type + ". No @Operation annotation found on class.");
        }
        this.service = service;
        this.type = type;
        this.widgetDefinitionList = widgetDefinitionList;
        this.contributingComponent = contributingComponent;
        this.id = anno.id().length() == 0 ? type.getName() : anno.id();
        this.aliases = anno.aliases();
        this.params = new HashMap<String, Field>();
        this.methods = new ArrayList<InvokableMethod>();
        this.injectableFields = new ArrayList<Field>();
        this.initMethods();
        this.initFields();
    }

    @Override
    public AutomationService getService() {
        return this.service;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getInputType() {
        return this.inputType;
    }

    protected void initMethods() {
        for (Method method : this.type.getMethods()) {
            OperationMethod anno = method.getAnnotation(OperationMethod.class);
            if (anno == null) continue;
            InvokableMethod im = new InvokableMethod(this, method, anno);
            this.methods.add(im);
            if (anno.collector() == OutputCollector.class) continue;
            im = new InvokableIteratorMethod(this, method, anno);
            this.methods.add(im);
        }
        Collections.sort(this.methods);
    }

    protected void initFields() {
        for (Field field : this.type.getDeclaredFields()) {
            Param param = field.getAnnotation(Param.class);
            if (param != null) {
                field.setAccessible(true);
                this.params.put(param.name(), field);
                continue;
            }
            if (!field.isAnnotationPresent(Context.class)) continue;
            field.setAccessible(true);
            this.injectableFields.add(field);
        }
    }

    @Override
    public Object newInstance(OperationContext ctx, Map<String, Object> args) throws OperationException {
        Object obj;
        try {
            obj = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new OperationException(e);
        }
        this.inject(ctx, args, obj);
        return obj;
    }

    protected Object resolveObject(OperationContext ctx, String key, Map<String, ?> args) {
        Object obj = args.get(key);
        if (obj != null) {
            return ctx.resolve(obj);
        }
        return ctx.getChainParameter(key);
    }

    public void inject(OperationContext ctx, Map<String, ?> args, Object target) throws OperationException {
        Object obj;
        for (Map.Entry<String, Field> entry : this.params.entrySet()) {
            String[] entryAliases;
            obj = this.resolveObject(ctx, entry.getKey(), args);
            if (obj == null && (entryAliases = entry.getValue().getAnnotation(Param.class).alias()) != null) {
                String alias;
                String[] stringArray = entry.getValue().getAnnotation(Param.class).alias();
                int n = stringArray.length;
                for (int i = 0; i < n && (obj = this.resolveObject(ctx, alias = stringArray[i], args)) == null; ++i) {
                }
            }
            if (obj == null) {
                if (!entry.getValue().getAnnotation(Param.class).required()) continue;
                throw new OperationException("Failed to inject parameter '" + entry.getKey() + "'. Seems it is missing from the context. Operation: " + this.getId());
            }
            Field field = entry.getValue();
            Class<?> cl = obj.getClass();
            if (!field.getType().isAssignableFrom(cl)) {
                obj = this.service.getAdaptedValue(ctx, obj, field.getType());
            }
            try {
                field.set(target, obj);
            }
            catch (ReflectiveOperationException e) {
                throw new OperationException(e);
            }
        }
        for (Field field : this.injectableFields) {
            obj = ctx.getAdapter(field.getType());
            try {
                field.set(target, obj);
            }
            catch (ReflectiveOperationException e) {
                throw new OperationException(e);
            }
        }
    }

    @Override
    public InvokableMethod[] getMethodsMatchingInput(Class<?> in) {
        ArrayList<Match> result = new ArrayList<Match>();
        for (InvokableMethod m : this.methods) {
            int priority = m.inputMatch(in);
            if (priority <= 0) continue;
            result.add(new Match(m, priority));
        }
        int size = result.size();
        if (size == 0) {
            return new InvokableMethod[0];
        }
        if (size == 1) {
            return new InvokableMethod[]{((Match)result.get((int)0)).method};
        }
        Collections.sort(result);
        InvokableMethod[] ar = new InvokableMethod[result.size()];
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = ((Match)result.get((int)i)).method;
        }
        return ar;
    }

    @Override
    public OperationDocumentation getDocumentation() {
        Operation op = this.type.getAnnotation(Operation.class);
        OperationDocumentation doc = new OperationDocumentation(op.id());
        doc.label = op.label();
        doc.requires = op.requires();
        doc.category = op.category();
        doc.since = op.since();
        doc.deprecatedSince = op.deprecatedSince();
        doc.addToStudio = op.addToStudio();
        doc.setAliases(op.aliases());
        doc.implementationClass = this.type.getName();
        if (doc.requires.length() == 0) {
            doc.requires = null;
        }
        if (doc.label.length() == 0) {
            doc.label = doc.id;
        }
        doc.description = op.description();
        LinkedList<OperationDocumentation.Param> paramsAccumulator = new LinkedList<OperationDocumentation.Param>();
        for (Field field : this.params.values()) {
            Param p = field.getAnnotation(Param.class);
            OperationDocumentation.Param param = new OperationDocumentation.Param();
            param.name = p.name();
            param.description = p.description();
            param.type = this.getParamDocumentationType(field.getType());
            param.widget = p.widget();
            if (param.widget.length() == 0) {
                param.widget = null;
            }
            param.order = p.order();
            param.values = p.values();
            param.required = p.required();
            paramsAccumulator.add(param);
        }
        Collections.sort(paramsAccumulator);
        doc.params = paramsAccumulator.toArray(new OperationDocumentation.Param[paramsAccumulator.size()]);
        ArrayList<String> result = new ArrayList<String>(this.methods.size() * 2);
        HashSet<CallSite> collectedSigs = new HashSet<CallSite>();
        for (InvokableMethod m : this.methods) {
            String out;
            String in = this.getParamDocumentationType(m.getInputType(), m.isIterable());
            String sigKey = in + ":" + (out = this.getParamDocumentationType(m.getOutputType()));
            if (collectedSigs.contains(sigKey)) continue;
            result.add(in);
            result.add(out);
            collectedSigs.add((CallSite)((Object)sigKey));
        }
        doc.signature = result.toArray(new String[result.size()]);
        if (this.widgetDefinitionList != null) {
            doc.widgetDefinitions = this.widgetDefinitionList.toArray(new WidgetDefinition[this.widgetDefinitionList.size()]);
        }
        return doc;
    }

    @Override
    public String getContributingComponent() {
        return this.contributingComponent;
    }

    protected String getParamDocumentationType(Class<?> type) {
        return this.getParamDocumentationType(type, false);
    }

    protected String getParamDocumentationType(Class<?> type, boolean isIterable) {
        String t = DocumentModel.class.isAssignableFrom(type) || DocumentRef.class.isAssignableFrom(type) ? (isIterable ? "documents" : "document") : (DocumentModelList.class.isAssignableFrom(type) || DocumentRefList.class.isAssignableFrom(type) ? "documents" : (BlobList.class.isAssignableFrom(type) ? "bloblist" : (Blob.class.isAssignableFrom(type) ? (isIterable ? "bloblist" : "blob") : (URL.class.isAssignableFrom(type) ? "resource" : (Calendar.class.isAssignableFrom(type) ? "date" : type.getSimpleName().toLowerCase())))));
        return t;
    }

    public String toString() {
        return "OperationTypeImpl [id=" + this.id + ", type=" + this.type + ", params=" + this.params + "]";
    }

    @Override
    public List<InvokableMethod> getMethods() {
        return this.methods;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public OperationTypeImpl clone() {
        OperationTypeImpl clone = new OperationTypeImpl(this.service, this.type, this.contributingComponent, this.widgetDefinitionList);
        clone.inputType = this.inputType;
        return clone;
    }

    @Override
    public void merge(OperationType other) {
        OperationTypeImpl ot = (OperationTypeImpl)other;
        this.enabled = ot.isEnabled();
        this.service = ot.service;
        this.aliases = ot.aliases;
        this.params = ot.params;
        this.inputType = ot.getInputType();
        this.contributingComponent = ot.getContributingComponent();
        this.methods = ot.getMethods();
        this.type = ot.type;
        this.injectableFields = ot.injectableFields;
        this.widgetDefinitionList = ot.widgetDefinitionList;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append(this.type).append(this.enabled).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OperationTypeImpl)) {
            return false;
        }
        OperationTypeImpl ot = (OperationTypeImpl)obj;
        return this.id.equals(ot.getId()) && this.type.equals(ot.type) && this.enabled == ot.enabled;
    }

    static class Match
    implements Comparable<Match> {
        protected InvokableMethod method;
        int priority;

        Match(InvokableMethod method, int priority) {
            this.method = method;
            this.priority = priority;
        }

        @Override
        public int compareTo(Match o) {
            return o.priority - this.priority;
        }

        public String toString() {
            return "Match(" + this.method + ", " + this.priority + ")";
        }
    }
}

