/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

@Operation(id="Document.BlockPermissionInheritance", category="Document", label="Block Permission Inheritance", description="Block the permission inheritance on the input document(s). Returns the document(s).")
public class BlockPermissionInheritance {
    public static final String ID = "Document.BlockPermissionInheritance";
    @Context
    protected CoreSession session;
    @Param(name="acl", required=false, values={"local"}, description="ACL name.")
    String aclName = "local";

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        this.blockPermissionInheritance(doc);
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) {
        DocumentModel doc = this.session.getDocument(docRef);
        this.blockPermissionInheritance(doc);
        return doc;
    }

    protected void blockPermissionInheritance(DocumentModel doc) {
        String username;
        Object acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        boolean permissionChanged = acp.blockInheritance(this.aclName, username = this.session.getPrincipal().getName());
        if (permissionChanged) {
            doc.setACP(acp, true);
        }
    }
}

