/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.Copy", label="Copy", category="Document", description="Copy the input document into the given Folderish. The name parameter will be used as the copy name otherwise if not specified the original name will be preserved. The target Folderish can be specified as an absolute or relative path (relative to the input document) as an UID or by using an EL expression. Return the newly created document (the copy). The document is copied with its children recursively. The resetLifeCycle parameter allows to reset the life cycle of the copied document.")
public class CopyDocument {
    public static final String ID = "Document.Copy";
    @Context
    protected CoreSession session;
    @Param(name="target")
    protected DocumentRef target;
    @Param(name="name", required=false)
    protected String name;
    @Param(name="resetLifeCycle", required=false)
    protected boolean resetLifeCycle;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        String n = this.name;
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            n = doc.getName();
        }
        ArrayList<CoreSession.CopyOption> options = new ArrayList<CoreSession.CopyOption>();
        if (this.resetLifeCycle) {
            options.add(CoreSession.CopyOption.RESET_LIFE_CYCLE);
        }
        return this.session.copy(doc.getRef(), this.target, n, (CoreSession.CopyOption[])options.toArray(CoreSession.CopyOption[]::new));
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef ref) {
        return this.run(this.session.getDocument(ref));
    }
}

