/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.automation.core.util.JSONManagedBlobDecoder;
import org.nuxeo.ecm.automation.core.util.JSONObjectBlobDecoder;
import org.nuxeo.ecm.automation.core.util.JSONStringBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;

public class ComplexTypeJSONDecoder {
    private static final ObjectMapper mapper = new ObjectMapper();
    protected static List<JSONBlobDecoder> blobDecoders = new ArrayList<JSONBlobDecoder>();

    public static void registerBlobDecoder(JSONBlobDecoder blobDecoder) {
        blobDecoders.add(blobDecoder);
    }

    public static List<Object> decodeList(ListType lt, String json) throws IOException {
        ArrayNode jsonArray = (ArrayNode)mapper.readTree(json);
        return ComplexTypeJSONDecoder.decodeList(lt, jsonArray);
    }

    public static List<Object> decodeList(ListType lt, ArrayNode jsonArray) {
        ArrayList<Object> result = new ArrayList<Object>();
        Type currentObjectType = lt.getFieldType();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonNode node = jsonArray.get(i);
            if (node.isArray()) {
                result.add(ComplexTypeJSONDecoder.decodeList((ListType)currentObjectType, (ArrayNode)node));
                continue;
            }
            if (node.isObject()) {
                result.add(ComplexTypeJSONDecoder.decode((ComplexType)currentObjectType, (ObjectNode)node));
                continue;
            }
            if (node.isTextual()) {
                result.add(node.textValue());
                continue;
            }
            if (node.isNumber()) {
                result.add(node.numberValue());
                continue;
            }
            if (!node.isBoolean()) continue;
            result.add(node.booleanValue());
        }
        return result;
    }

    public static Object decode(ComplexType ct, String json) throws IOException {
        ObjectNode jsonObject = (ObjectNode)mapper.readTree(json);
        return ComplexTypeJSONDecoder.decode(ct, jsonObject);
    }

    public static Object decode(ComplexType ct, ObjectNode jsonObject) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String jsonType = "";
        if (jsonObject.has("type")) {
            jsonType = jsonObject.get("type").textValue();
        }
        if (jsonType.equals("blob") || ct.getName().equals("content")) {
            return ComplexTypeJSONDecoder.getBlobFromJSON(jsonObject);
        }
        Iterator it = jsonObject.fields();
        while (it.hasNext()) {
            Map.Entry nodeEntry = (Map.Entry)it.next();
            if (!ct.hasField((String)nodeEntry.getKey())) continue;
            Field field = ct.getField((String)nodeEntry.getKey());
            Type fieldType = field.getType();
            if (fieldType.isSimpleType()) {
                Object value;
                if (fieldType == DateType.INSTANCE && ((JsonNode)nodeEntry.getValue()).isIntegralNumber()) {
                    value = Calendar.getInstance();
                    ((Calendar)value).setTimeInMillis(((JsonNode)nodeEntry.getValue()).asLong());
                } else {
                    value = ((SimpleType)fieldType).decode(((JsonNode)nodeEntry.getValue()).asText());
                }
                result.put((String)nodeEntry.getKey(), value);
                continue;
            }
            JsonNode subNode = (JsonNode)nodeEntry.getValue();
            if (subNode.isArray()) {
                result.put((String)nodeEntry.getKey(), ComplexTypeJSONDecoder.decodeList((ListType)fieldType, (ArrayNode)subNode));
                continue;
            }
            result.put((String)nodeEntry.getKey(), ComplexTypeJSONDecoder.decode((ComplexType)fieldType, (ObjectNode)subNode));
        }
        return result;
    }

    public static Blob getBlobFromJSON(ObjectNode jsonObject) {
        Blob blob = null;
        for (JSONBlobDecoder blobDecoder : blobDecoders) {
            blob = blobDecoder.getBlobFromJSON(jsonObject);
            if (blob == null) continue;
            return blob;
        }
        return blob;
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        blobDecoders.add(new JSONStringBlobDecoder());
        blobDecoders.add(new JSONObjectBlobDecoder());
        blobDecoders.add(new JSONManagedBlobDecoder());
    }
}

