/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class Properties
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    public static final String IS_PROPERTY_VALUE_TRIMMED_KEY = "nuxeo.automation.properties.value.trim";
    public static final String PROPERTIES_MULTILINE_ESCAPE = "nuxeo.automation.properties.multiline.escape";
    protected static final String multiLineEscape = (String)MoreObjects.firstNonNull((Object)Framework.getProperty((String)"nuxeo.automation.properties.multiline.escape"), (Object)"true");

    protected static boolean isPropertyValueTrimmed() {
        return ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanTrue(IS_PROPERTY_VALUE_TRIMMED_KEY);
    }

    public Properties() {
    }

    public Properties(int size) {
        super(size);
    }

    public Properties(Map<String, String> props) {
        super(props);
    }

    public Properties(String content) throws IOException {
        StringReader reader = new StringReader(content);
        HashMap<String, String> props = new HashMap<String, String>();
        Properties.loadProperties(reader, props);
        this.putAll(props);
    }

    public Properties(JsonNode node) throws IOException {
        Iterator fields = node.fields();
        ObjectMapper om = new ObjectMapper();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            JsonNode subNode = (JsonNode)entry.getValue();
            this.put(key, this.extractValueFromNode(subNode, om));
        }
    }

    private String extractValueFromNode(JsonNode node, ObjectMapper om) throws IOException {
        if (!node.isNull()) {
            return node.isContainerNode() ? om.writeValueAsString((Object)node) : node.asText();
        }
        return null;
    }

    public static Map<String, String> loadProperties(Reader reader) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties.loadProperties(reader, map);
        return map;
    }

    public static void loadProperties(Reader reader, Map<String, String> map) throws IOException {
        boolean isPropertyValueToBeTrimmed = Properties.isPropertyValueTrimmed();
        BufferedReader in = new BufferedReader(reader);
        Object line = in.readLine();
        String prevLine = null;
        String lineSeparator = "\n";
        while (line != null) {
            if (prevLine == null && (((String)line).startsWith("#") || StringUtils.isBlank((CharSequence)line))) {
                line = in.readLine();
                continue;
            }
            if (((String)line).endsWith("\\") && Boolean.parseBoolean(multiLineEscape)) {
                line = ((String)line).substring(0, ((String)line).length() - 1);
                prevLine = (String)(prevLine != null ? prevLine + (String)line : line) + lineSeparator;
                line = in.readLine();
                continue;
            }
            if (prevLine != null) {
                line = prevLine + (String)line;
            }
            prevLine = null;
            Properties.setPropertyLine(map, (String)line, isPropertyValueToBeTrimmed);
            line = in.readLine();
        }
        if (prevLine != null) {
            Properties.setPropertyLine(map, prevLine, isPropertyValueToBeTrimmed);
        }
    }

    private static void setPropertyLine(Map<String, String> map, String line, boolean isPropertyValueToBeTrimmed) throws IOException {
        int i = line.indexOf(61);
        if (i == -1) {
            throw new IOException("Invalid property line (cannot find a '=') in: '" + line + "'");
        }
        String value = line.substring(i + 1);
        if (isPropertyValueToBeTrimmed) {
            value = value.trim();
        }
        map.put(line.substring(0, i).trim(), value);
    }
}

