/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.core.events.EventHandler;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class EventRegistry
extends ContributionFragmentRegistry<EventHandler> {
    private static final Logger log = LogManager.getLogger(EventRegistry.class);
    protected volatile Map<String, List<EventHandler>> lookup;

    public String getContributionId(EventHandler contrib) {
        Object id = contrib.getId();
        if (id == null) {
            id = contrib.chainId;
            if (contrib.events != null && !contrib.events.isEmpty()) {
                id = (String)id + "_" + String.join((CharSequence)"_", contrib.events);
            }
            log.debug("An EventHandler without id has been contributed. Generated id: {} ", id);
        }
        return id;
    }

    public void contributionUpdated(String id, EventHandler handler, EventHandler newOrigContrib) {
        this.lookup = null;
    }

    public void contributionRemoved(String id, EventHandler handler) {
        this.lookup = null;
    }

    public EventHandler clone(EventHandler orig) {
        return orig.clone();
    }

    public void merge(EventHandler src, EventHandler dst) {
        dst.merge(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<EventHandler>> lookup() {
        if (this.lookup == null) {
            EventRegistry eventRegistry = this;
            synchronized (eventRegistry) {
                if (this.lookup == null) {
                    this.lookup = new HashMap<String, List<EventHandler>>();
                    for (EventHandler eventHandler : this.toMap().values()) {
                        if (!eventHandler.isEnabled()) continue;
                        for (String eventId : eventHandler.getEvents()) {
                            this.lookup.computeIfAbsent(eventId, k -> new ArrayList()).add(eventHandler);
                        }
                    }
                }
            }
        }
        return this.lookup;
    }
}

