/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class OperationTypeRegistry
extends ContributionFragmentRegistry<OperationType> {
    protected volatile Map<String, OperationType> lookup;

    public String getContributionId(OperationType contrib) {
        return contrib.getId();
    }

    public synchronized void addContribution(OperationType op, boolean replace) throws OperationException {
        if (!replace && !this.contribs.getOrDefault(op.getId(), new ContributionFragmentRegistry.FragmentList()).isEmpty()) {
            throw new OperationException("An operation is already bound to: " + op.getId() + ". Use 'replace=true' to replace an existing operation");
        }
        OperationType target = (OperationType)this.getContribution(op.getId());
        if (target != null && !op.getClass().equals(target.getClass())) {
            throw new UnsupportedOperationException("Can't merge operations with id: " + op.getId() + ". The type " + op.getClass() + " cannot be merged in " + target.getClass() + ".");
        }
        super.addContribution((Object)op);
    }

    public void contributionUpdated(String id, OperationType contrib, OperationType newOrigContrib) {
        this.lookup = null;
    }

    public void contributionRemoved(String id, OperationType origContrib) {
        this.lookup = null;
    }

    public OperationType clone(OperationType orig) {
        return orig.clone();
    }

    public void merge(OperationType src, OperationType dst) {
        dst.merge(src);
    }

    public OperationType getOperationType(Class<?> key) {
        return this.lookup().get(key.getAnnotation(Operation.class).id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, OperationType> lookup() {
        if (this.lookup == null) {
            OperationTypeRegistry operationTypeRegistry = this;
            synchronized (operationTypeRegistry) {
                if (this.lookup == null) {
                    this.lookup = new HashMap<String, OperationType>();
                    for (OperationType operation : this.toMap().values()) {
                        if (!operation.isEnabled()) continue;
                        this.lookup.put(operation.getId(), operation);
                        if (operation.getAliases() == null) continue;
                        for (String alias : operation.getAliases()) {
                            this.lookup.put(alias, operation);
                        }
                    }
                }
            }
        }
        return this.lookup;
    }
}

