/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.convert.ConvertHelper;

@Operation(id="Blob.Convert", category="Conversion", label="Convert to given mime-type", description="Convert the input file to a file of the given mime-type and return the new file.", since="5.7")
public class ConvertBlob {
    public static final String ID = "Blob.Convert";
    protected final ConvertHelper convertHelper = new ConvertHelper();
    @Context
    protected ConversionService service;
    @Param(name="mimeType", required=true)
    protected String mimeType;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        return this.run(bh.getBlob());
    }

    @OperationMethod
    public Blob run(Blob blob) {
        Blob result = this.convertHelper.convertBlob(blob, this.mimeType);
        return result;
    }

    @OperationMethod
    public BlobList run(BlobList blobs) {
        BlobList bl = new BlobList();
        for (Blob blob : blobs) {
            bl.add(this.run(blob));
        }
        return bl;
    }
}

