/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;

@Operation(id="Document.RemovePermission", category="Document", label="Remove Permission", description="Remove a permission given its id or all permissions for a given user on the input document(s). Parameter 'id' or 'user' must be set. Returns the document(s).")
public class RemovePermission {
    public static final String ID = "Document.RemovePermission";
    @Context
    protected CoreSession session;
    @Param(name="id", required=false)
    protected String id;
    @Param(name="user", required=false)
    protected String user;
    @Param(name="acl", required=false)
    String aclName = "local";

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        this.removePermission(doc);
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) {
        DocumentModel doc = this.session.getDocument(docRef);
        this.removePermission(doc);
        return doc;
    }

    protected void removePermission(DocumentModel doc) {
        if (this.id == null && this.user == null) {
            throw new IllegalParameterException("'id' or 'user' parameter must be set");
        }
        ACP acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        boolean permissionChanged = false;
        if (this.user != null) {
            permissionChanged = acp.removeACEsByUsername(this.aclName, this.user);
        } else if (this.id != null) {
            ACE ace = ACE.fromId((String)this.id);
            permissionChanged = acp.removeACE(this.aclName, ace);
        }
        if (permissionChanged) {
            doc.setACP(acp, true);
        }
    }
}

