/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.scripting;

import groovy.lang.Binding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.mvel2.MVEL;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.context.ContextService;
import org.nuxeo.ecm.automation.core.scripting.DateWrapper;
import org.nuxeo.ecm.automation.core.scripting.DocumentWrapper;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.GroovyScripting;
import org.nuxeo.ecm.automation.core.scripting.MvelExpression;
import org.nuxeo.ecm.automation.core.scripting.MvelTemplate;
import org.nuxeo.ecm.automation.core.scripting.PrincipalWrapper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.runtime.api.Framework;

public class Scripting {
    protected static final Map<String, Script> cache = new ConcurrentHashMap<String, Script>();
    protected static final GroovyScripting gscripting = new GroovyScripting();

    public static Expression newExpression(String expr) {
        return new MvelExpression(expr);
    }

    public static Expression newTemplate(String expr) {
        return new MvelTemplate(expr);
    }

    public static void run(OperationContext ctx, URL script) throws OperationException, IOException {
        String key = script.toExternalForm();
        Script cs = cache.get(key);
        if (cs != null) {
            cs.eval(ctx);
            return;
        }
        String path = script.getPath();
        int p = path.lastIndexOf(46);
        if (p == -1) {
            throw new OperationException("Script files must have an extension: " + script);
        }
        String ext = path.substring(p + 1).toLowerCase();
        try (InputStream in = script.openStream();){
            if ("mvel".equals(ext)) {
                Serializable c = MVEL.compileExpression((String)IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
                cs = new MvelScript(c);
            } else if ("groovy".equals(ext)) {
                cs = new GroovyScript(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
            } else {
                throw new OperationException("Unsupported script file: " + script + ". Only MVEL and Groovy scripts are supported");
            }
            cache.put(key, cs);
            cs.eval(ctx);
        }
    }

    public static Map<String, Object> initBindings(OperationContext ctx) {
        Object input = ctx.getInput();
        HashMap<String, Object> map = new HashMap<String, Object>(ctx.getVars());
        map.put("CurrentDate", new DateWrapper());
        map.put("Context", ctx);
        if (ctx.get("WorkflowVariables") != null) {
            map.put("WorkflowVariables", ctx.get("WorkflowVariables"));
        }
        if (ctx.get("NodeVariables") != null) {
            map.put("NodeVariables", ctx.get("NodeVariables"));
        }
        map.put("This", input);
        map.put("Session", ctx.getCoreSession());
        PrincipalWrapper principalWrapper = new PrincipalWrapper(ctx.getPrincipal());
        map.put("CurrentUser", principalWrapper);
        map.put("currentUser", principalWrapper);
        map.put("Env", Framework.getProperties());
        ContextService contextService = (ContextService)Framework.getService(ContextService.class);
        map.putAll(contextService.getHelperFunctions());
        if (input instanceof DocumentModel) {
            DocumentWrapper documentWrapper = new DocumentWrapper(ctx.getCoreSession(), (DocumentModel)input);
            map.put("Document", documentWrapper);
            map.put("currentDocument", documentWrapper);
        }
        if (input instanceof DocumentModelList) {
            ArrayList<DocumentWrapper> docs = new ArrayList<DocumentWrapper>();
            for (DocumentModel doc : (DocumentModelList)input) {
                docs.add(new DocumentWrapper(ctx.getCoreSession(), doc));
            }
            map.put("Documents", docs);
            if (!docs.isEmpty()) {
                map.put("Document", docs.get(0));
            }
        }
        return map;
    }

    public static class GroovyScript
    implements Script {
        final groovy.lang.Script c;

        public GroovyScript(String c) {
            this.c = gscripting.getScript(c, new Binding());
        }

        @Override
        public Object eval(OperationContext ctx) {
            Binding binding = new Binding();
            for (Map.Entry<String, Object> entry : Scripting.initBindings(ctx).entrySet()) {
                binding.setVariable(entry.getKey(), entry.getValue());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            binding.setVariable("out", (Object)new PrintStream(baos));
            this.c.setBinding(binding);
            this.c.run();
            return baos;
        }
    }

    public static class MvelScript
    implements Script {
        final Serializable c;

        public static MvelScript compile(String script) {
            return new MvelScript(MVEL.compileExpression((String)script));
        }

        public MvelScript(Serializable c) {
            this.c = c;
        }

        @Override
        public Object eval(OperationContext ctx) {
            return MVEL.executeExpression((Object)this.c, Scripting.initBindings(ctx));
        }
    }

    public static interface Script {
        public Object eval(OperationContext var1);
    }
}

