/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.automation.core.util.DataModelProperties;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;

public class DocumentHelper {
    private static final Logger log = LogManager.getLogger(DocumentHelper.class);
    public static final String SET_PROPERTY_BEHAVIOR_APPEND_INCLUDING_DUPLICATES = "append_including_duplicates";
    public static final String SET_PROPERTY_BEHAVIOR_APPEND_EXCLUDING_DUPLICATES = "append_excluding_duplicates";
    public static final String SET_PROPERTY_BEHAVIOR_REPLACE = "replace";

    private DocumentHelper() {
    }

    public static DocumentModel saveDocument(CoreSession session, DocumentModel doc) {
        doc = session.saveDocument(doc);
        return session.getDocument(doc.getRef());
    }

    public static void removeProperty(DocumentModel doc, String xpath) {
        Property p = doc.getProperty(xpath);
        if (p instanceof ListProperty) {
            ((ListProperty)p).clear();
        } else {
            Property pp = p.getParent();
            if (pp != null && pp.isList()) {
                ((ListProperty)pp).remove(p);
            } else {
                p.remove();
            }
        }
    }

    public static void addBlob(Property p, Blob blob) throws PropertyException {
        if (p.isList()) {
            Type ft = ((ListProperty)p).getType().getFieldType();
            if (ft.isComplexType() && ((ComplexType)ft).getFieldsCount() == 1) {
                p.addValue(DocumentHelper.createBlobHolderMap(blob));
            } else {
                p.addValue((Object)blob);
            }
        } else {
            p.setValue((Object)blob);
        }
    }

    public static HashMap<String, Serializable> createBlobHolderMap(Blob blob) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("file", (Serializable)blob);
        return map;
    }

    public static void setProperties(CoreSession session, DocumentModel doc, Properties properties) throws IOException, PropertyException {
        DocumentHelper.setProperties(session, doc, properties, null);
    }

    public static void setProperties(CoreSession session, DocumentModel doc, Properties properties, Properties propertiesBehaviors) throws IOException {
        if (properties instanceof DataModelProperties) {
            DataModelProperties dataModelProperties = (DataModelProperties)properties;
            for (Map.Entry<String, Serializable> entry : dataModelProperties.getMap().entrySet()) {
                doc.setPropertyValue(entry.getKey(), entry.getValue());
            }
        }
        if (propertiesBehaviors == null) {
            propertiesBehaviors = new Properties();
        }
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            DocumentHelper.setProperty(session, doc, key, value, (String)propertiesBehaviors.get(key));
        }
    }

    public static void setProperties(CoreSession session, DocumentModel doc, Map<String, String> values) throws IOException {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            DocumentHelper.setProperty(session, doc, key, value);
        }
    }

    public static void setProperty(CoreSession session, DocumentModel doc, String key, String value) throws IOException {
        DocumentHelper.setProperty(session, doc, key, value, false);
    }

    public static void setProperty(CoreSession session, DocumentModel doc, String key, String value, String behavior) throws IOException {
        DocumentHelper.setProperty(session, doc, key, value, behavior, false);
    }

    protected static void setLocalAcl(CoreSession session, DocumentModel doc, String value) {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl("local");
        acp.addACL((ACL)acl);
        String[] entries = StringUtils.split((String)value, (char)',', (boolean)true);
        if (entries.length == 0) {
            return;
        }
        for (String entry : entries) {
            String[] ace = StringUtils.split((String)entry, (char)':', (boolean)true);
            acl.add(new ACE(ace[0], ace[1], Boolean.parseBoolean(ace[2])));
        }
        session.setACP(doc.getRef(), (ACP)acp, false);
    }

    public static Object readStringList(String value, SimpleType type) {
        if (!type.isPrimitive()) {
            return DocumentHelper.readStringList(value, (SimpleType)type.getPrimitiveType());
        }
        String[] ar = DocumentHelper.readStringList(value);
        if (ar == null) {
            return null;
        }
        if (StringType.INSTANCE == type) {
            return ar;
        }
        if (DateType.INSTANCE == type) {
            Calendar[] r = new Calendar[ar.length];
            for (int i = 0; i < r.length; ++i) {
                r[i] = (Calendar)type.decode(ar[i]);
            }
            return r;
        }
        if (LongType.INSTANCE == type) {
            Long[] r = new Long[ar.length];
            for (int i = 0; i < r.length; ++i) {
                r[i] = (Long)type.decode(ar[i]);
            }
            return r;
        }
        if (IntegerType.INSTANCE == type) {
            Integer[] r = new Integer[ar.length];
            for (int i = 0; i < r.length; ++i) {
                r[i] = (Integer)type.decode(ar[i]);
            }
            return r;
        }
        if (DoubleType.INSTANCE == type) {
            Double[] r = new Double[ar.length];
            for (int i = 0; i < r.length; ++i) {
                r[i] = (Double)type.decode(ar[i]);
            }
            return r;
        }
        if (BooleanType.INSTANCE == type) {
            Boolean[] r = new Boolean[ar.length];
            for (int i = 0; i < r.length; ++i) {
                r[i] = (Boolean)type.decode(ar[i]);
            }
            return r;
        }
        if (BinaryType.INSTANCE == type) {
            InputStream[] r = new InputStream[ar.length];
            for (int i = 0; i < r.length; ++i) {
                r[i] = (InputStream)type.decode(ar[i]);
            }
            return r;
        }
        throw new IllegalArgumentException("Unsupported type when updating document properties from string representation: " + type);
    }

    public static String[] readStringList(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        char[] chars = value.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean esc = false;
        for (char c : chars) {
            if (c == '\\') {
                if (esc) {
                    sb.append('\\');
                    esc = false;
                    continue;
                }
                esc = true;
                continue;
            }
            if (c == ',') {
                if (esc) {
                    sb.append(',');
                    esc = false;
                    continue;
                }
                result.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        result.add(sb.toString());
        return result.toArray(new String[result.size()]);
    }

    public static void setJSONProperties(CoreSession session, DocumentModel doc, Properties properties) throws IOException {
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            DocumentHelper.setProperty(session, doc, key, value, true);
        }
    }

    public static void setProperty(CoreSession session, DocumentModel doc, String key, String value, boolean decodeStringListAsJSON) throws IOException {
        DocumentHelper.setProperty(session, doc, key, value, null, decodeStringListAsJSON);
    }

    public static void setProperty(CoreSession session, DocumentModel doc, String key, String value, String behavior, boolean decodeStringListAsJSON) throws IOException {
        Property p = doc.getProperty(key);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((Property)p).getXPath();
        supplierArray[1] = () -> behavior;
        log.debug("Set property: {} with behavior: {}", supplierArray);
        if ("ecm:acl".equals(key)) {
            DocumentHelper.setLocalAcl(session, doc, value);
        }
        if (value == null || value.length() == 0) {
            p.setValue(null);
            return;
        }
        Type type = p.getField().getType();
        if (!type.isSimpleType()) {
            if (type.isListType()) {
                DocumentHelper.setListProperty(type, behavior, decodeStringListAsJSON, value, p);
                return;
            }
            if (type.isComplexType()) {
                Object val = ComplexTypeJSONDecoder.decode((ComplexType)type, value);
                p.setValue(val);
                return;
            }
            throw new NuxeoException("Property type is not supported by this operation");
        }
        p.setValue(((SimpleType)type).getPrimitiveType().decode(value));
    }

    protected static void setListProperty(Type type, String behavior, boolean decodeStringListAsJSON, String value, Property p) throws IOException {
        ListType ltype = (ListType)type;
        if (behavior == null || p.getValue() == null) {
            behavior = SET_PROPERTY_BEHAVIOR_REPLACE;
        }
        if (ltype.isScalarList() && !decodeStringListAsJSON) {
            Object val = DocumentHelper.readStringList(value, (SimpleType)ltype.getFieldType());
            if (SET_PROPERTY_BEHAVIOR_APPEND_EXCLUDING_DUPLICATES.equals(behavior)) {
                if (val == null) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = () -> ((Property)p).getXPath();
                    log.debug("Value of property: {} not found", supplierArray);
                } else {
                    ArrayList<Object> currentProps = new ArrayList<Object>((Collection)p.getValue(List.class));
                    for (Object valueToSet : List.of((Object[])val)) {
                        if (currentProps.contains(valueToSet)) continue;
                        currentProps.add(valueToSet);
                    }
                    p.setValue(currentProps);
                }
            } else if (SET_PROPERTY_BEHAVIOR_APPEND_INCLUDING_DUPLICATES.equals(behavior)) {
                if (val == null) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = () -> ((Property)p).getXPath();
                    log.debug("Value of property: {} not found", supplierArray);
                } else {
                    ArrayList<Object> list = new ArrayList<Object>((Collection)p.getValue(List.class));
                    list.addAll(List.of((Object[])val));
                    p.setValue(list);
                }
            } else {
                p.setValue(val);
            }
        } else {
            List<Object> val = ComplexTypeJSONDecoder.decodeList(ltype, value);
            if (SET_PROPERTY_BEHAVIOR_APPEND_INCLUDING_DUPLICATES.equals(behavior)) {
                val.forEach(arg_0 -> ((Property)p).addValue(arg_0));
            } else if (SET_PROPERTY_BEHAVIOR_APPEND_EXCLUDING_DUPLICATES.equals(behavior)) {
                List currentProps = (List)p.getValue(List.class);
                for (Object valueToSet : val) {
                    if (currentProps.contains(valueToSet)) continue;
                    p.addValue(valueToSet);
                }
            } else {
                p.setValue(val);
            }
        }
    }
}

