/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;

public class ExecResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TIMEOUT_RETURN_CODE = 137;
    protected final String commandLine;
    protected final List<String> output;
    protected final long execTime;
    protected boolean success;
    protected final CommandException error;
    protected int returnCode;

    public ExecResult(String commandLine, List<String> output, long execTime, int returnCode) {
        this.commandLine = commandLine;
        this.execTime = execTime;
        this.output = output;
        this.returnCode = returnCode;
        boolean bl = this.success = returnCode == 0;
        this.error = !this.success ? new CommandException(String.format("Error code %d%s after %.2fs for %s\noutput: %s", returnCode, this.isCommandInTimeout() ? " (timeout)" : "", (double)execTime / 1000.0, commandLine, StringUtils.join(output, (String)"\n  "))) : null;
    }

    public ExecResult(String commandLine, Exception error) {
        this.commandLine = commandLine;
        this.execTime = 0L;
        this.output = null;
        this.returnCode = 1;
        this.success = false;
        this.error = new CommandException(String.format("Error while running %s", commandLine), error);
    }

    public ExecResult(String timeoutError) {
        this(null, Collections.singletonList(timeoutError), 0L, 137);
    }

    public List<String> getOutput() {
        return this.output;
    }

    public long getExecTime() {
        return this.execTime;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public CommandException getError() {
        return this.error;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public boolean isCommandInTimeout() {
        return 137 == this.returnCode;
    }
}

