/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service.executors;

import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.EnvironmentDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.Executor;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ShellExecutor
implements Executor {
    private static final Logger log = LogManager.getLogger(ShellExecutor.class);
    protected static final AtomicInteger PIPE_COUNT = new AtomicInteger();
    protected static final Pattern COMMAND_SPLIT = Pattern.compile("\"([^\"]*)\"|'([^']*)'|[^\\s]+");
    protected final boolean useTimeout;
    public static final int DEFAULT_TIMEOUT_S = 86400;

    public ShellExecutor(boolean useTimeout) {
        this.useTimeout = useTimeout;
    }

    @Override
    public ExecResult exec(CommandLineDescriptor cmdDesc, CmdParameters params, EnvironmentDescriptor env) {
        ExecResult execResult;
        block8: {
            String commandLine = cmdDesc.getCommand() + " " + String.join((CharSequence)" ", cmdDesc.getParametersString());
            String dbgCommandLine = String.format("command: %s, parameters: %s", commandLine, params.getParameters().entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), ((CmdParameters.ParameterValue)e.getValue()).getValue())).collect(Collectors.joining(", ")));
            Scope ignored = this.getScopedSpan(cmdDesc.getName(), dbgCommandLine);
            try {
                log.debug("Running system {}", (Object)dbgCommandLine);
                long t0 = System.currentTimeMillis();
                ExecResult res = this.exec1(cmdDesc, params, env);
                long t1 = System.currentTimeMillis();
                log.error("time to run '{}' = {}", (Object)dbgCommandLine, (Object)(t1 - t0));
                execResult = new ExecResult(dbgCommandLine, res.getOutput(), t1 - t0, res.getReturnCode());
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    return new ExecResult(commandLine, e2);
                }
            }
            ignored.close();
        }
        return execResult;
    }

    protected Scope getScopedSpan(String name, String command) {
        Scope scope = Tracing.getTracer().spanBuilder("ShellExec: " + name).setSpanKind(Span.Kind.CLIENT).startScopedSpan();
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("command", AttributeValue.stringAttributeValue((String)command));
        Tracing.getTracer().getCurrentSpan().putAttributes(map);
        return scope;
    }

    protected ExecResult exec1(CommandLineDescriptor cmdDesc, CmdParameters params, EnvironmentDescriptor env) throws IOException {
        List output;
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.useTimeout) {
            try {
                list.add("timeout");
                list.add("-s");
                list.add("9");
                list.add(this.getTimeout(cmdDesc) + "s");
                log.debug("Prefixing command: {}, with {}", (Object)cmdDesc.getName(), list);
            }
            catch (TimeoutException e) {
                return new ExecResult(e.getMessage());
            }
        }
        list.add(cmdDesc.getCommand());
        Matcher m = COMMAND_SPLIT.matcher(cmdDesc.getParametersString());
        while (m.find()) {
            String word = m.group(1) != null ? m.group(1) : (m.group(2) != null ? m.group(2) : m.group());
            List<String> words = ShellExecutor.replaceParams(word, params);
            list.addAll(words);
        }
        LinkedList<ProcessBuilder> builders = new LinkedList<ProcessBuilder>();
        LinkedList<String> command = new LinkedList<String>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            boolean build;
            String word = (String)it.next();
            if (word.equals("|")) {
                build = true;
            } else {
                if (command.isEmpty() && SystemUtils.IS_OS_WINDOWS) {
                    command.add(ShellExecutor.getCommandAbsolutePath(word));
                } else {
                    command.add(word);
                }
                boolean bl = build = !it.hasNext();
            }
            if (!build) continue;
            ProcessBuilder processBuilder = this.createProcessBuilder(command, env);
            builders.add(processBuilder);
            log.trace("Add command: {}", command);
            command = new LinkedList();
        }
        List<Process> processes = ProcessBuilder.startPipeline(builders);
        Process last = processes.get(processes.size() - 1);
        try (BufferedInputStream stream = IOUtils.buffer((InputStream)last.getInputStream());){
            output = IOUtils.readLines((InputStream)stream, (Charset)Charset.defaultCharset());
        }
        int returnCode = this.getReturnCode(processes);
        return new ExecResult(null, output, 0L, returnCode);
    }

    protected int getTimeout(CommandLineDescriptor cmdDesc) throws TimeoutException {
        int timeout = cmdDesc.getTimeout() != null ? Math.toIntExact(cmdDesc.getTimeout().getSeconds()) : 86400;
        int ttl = TransactionHelper.getTransactionTimeToLive();
        if (ttl < 0) {
            return timeout;
        }
        if (ttl < 5) {
            throw new TimeoutException("Transaction life is too short to run shell command: " + ttl + "s");
        }
        return Math.min(ttl, timeout);
    }

    protected ProcessBuilder createProcessBuilder(List<String> command, EnvironmentDescriptor env) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        log.debug("Building Process for command: {}", new Supplier[]{() -> String.join((CharSequence)" ", processBuilder.command())});
        processBuilder.directory(new File(env.getWorkingDirectory()));
        processBuilder.environment().putAll(env.getParameters());
        processBuilder.redirectErrorStream(true);
        return processBuilder;
    }

    protected int getReturnCode(List<Process> processes) {
        int returnCode = 0;
        for (Process p : processes) {
            try {
                int exitCode = p.waitFor();
                if (returnCode != 0) continue;
                returnCode = exitCode;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeServiceException((Throwable)e);
            }
        }
        return returnCode;
    }

    @Deprecated(since="11.1")
    public static Thread pipe(InputStream in, OutputStream out) {
        Runnable run = () -> {
            try (InputStream inputStream = in;
                 OutputStream outputStream = out;){
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
            }
            catch (IOException e) {
                throw new RuntimeServiceException((Throwable)e);
            }
        };
        Thread thread = new Thread(run, "Nuxeo-pipe-" + PIPE_COUNT.incrementAndGet());
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static List<String> replaceParams(String word, CmdParameters params) {
        for (Map.Entry<String, CmdParameters.ParameterValue> es : params.getParameters().entrySet()) {
            String name = es.getKey();
            CmdParameters.ParameterValue paramVal = es.getValue();
            String param = "#{" + name + "}";
            if (paramVal.isMulti()) {
                if (!word.equals(param)) continue;
                return paramVal.getValues();
            }
            if (!word.contains(param)) continue;
            word = word.replace(param, paramVal.getValue());
        }
        return Collections.singletonList(word);
    }

    public static String getCommandAbsolutePath(String command) {
        if (Paths.get(command, new String[0]).isAbsolute()) {
            return command;
        }
        List<String> extensions = Arrays.asList("", ".exe");
        String[] systemPaths = System.getenv("PATH").split(File.pathSeparator);
        for (String ext : extensions) {
            for (String sp : systemPaths) {
                String fullCommand = command + ext;
                try {
                    Path path = Paths.get(sp.trim(), new String[0]);
                    if (!Files.exists(path.resolve(fullCommand), new LinkOption[0])) continue;
                    return path.resolve(fullCommand).toString();
                }
                catch (InvalidPathException e) {
                    log.warn("PATH environment variable contains an invalid path: {}", (Object)fullCommand, (Object)e);
                }
            }
        }
        return command;
    }
}

