/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.listener;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.function.ThrowableFunction;
import org.nuxeo.common.function.ThrowableSupplier;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.PictureViewsHelper;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;

public class PictureChangedListener
implements EventListener {
    @Deprecated
    public static final String EMPTY_PICTURE_PATH = "nuxeo.war/img/empty_picture.png";
    protected PictureViewsHelper pvh = new PictureViewsHelper();
    private static final Log log = LogFactory.getLog(PictureChangedListener.class);
    private static ImageInfo emptyPictureImageInfo;

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("Picture") && !doc.isProxy() && this.triggersPictureViewsGeneration(event, doc)) {
            this.preFillPictureViews(docCtx.getCoreSession(), doc);
        }
    }

    protected boolean triggersPictureViewsGeneration(Event event, DocumentModel doc) {
        Property fileProp = doc.getProperty("file:content");
        Property viewsProp = doc.getProperty("picture:views");
        boolean forceGeneration = Boolean.TRUE.equals(doc.getContextData("forceViewsGeneration"));
        boolean emptyPictureViews = viewsProp.size() == 0;
        boolean emptyOrNotDirtyPictureViews = !viewsProp.isDirty() || emptyPictureViews;
        boolean fileChanged = "aboutToCreate".equals(event.getName()) || fileProp.isDirty();
        return forceGeneration || emptyOrNotDirtyPictureViews && fileChanged;
    }

    protected void preFillPictureViews(CoreSession session, DocumentModel doc) {
        PictureResourceAdapter adapter = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
        adapter.clearInfo();
        try {
            Blob blob = (Blob)Optional.ofNullable(Thread.currentThread().getContextClassLoader().getResource(this.getEmptyPicturePath())).map(FileUtils::getFileFromURL).map(ThrowableFunction.asFunction(Blobs::createBlob)).orElseGet(ThrowableSupplier.asSupplier(() -> {
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getEmptyPicturePath());){
                    Blob b = Blobs.createBlob((InputStream)is);
                    b.setFilename(this.pvh.getEmptyPicturePath().lastSegment());
                    Blob blob = b;
                    return blob;
                }
            }));
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            String mimeType = mimetypeRegistry.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, null);
            blob.setMimeType(mimeType);
            DocumentModel parentDoc = this.getParentDocument(session, doc);
            ArrayList pictureConversions = null;
            if (parentDoc != null && "PictureBook".equals(parentDoc.getType()) && (pictureConversions = (ArrayList)parentDoc.getPropertyValue("picturebook:picturetemplates")).isEmpty()) {
                pictureConversions = null;
            }
            if (emptyPictureImageInfo == null) {
                ImagingService imagingService = (ImagingService)Framework.getService(ImagingService.class);
                emptyPictureImageInfo = imagingService.getImageInfo(blob);
            }
            adapter.preFillPictureViews(blob, pictureConversions, emptyPictureImageInfo);
        }
        catch (IOException e) {
            log.error((Object)("Error while pre-filling picture views: " + e.getMessage()), (Throwable)e);
        }
    }

    protected String getEmptyPicturePath() {
        return this.pvh.getEmptyPicturePath().toString();
    }

    protected DocumentModel getParentDocument(CoreSession session, DocumentModel doc) {
        DocumentModel parent;
        if (session.exists(doc.getRef())) {
            parent = session.getParentDocument(doc.getRef());
        } else {
            Path parentPath = doc.getPath().removeLastSegments(1);
            parent = session.getDocument((DocumentRef)new PathRef(parentPath.toString()));
        }
        return parent;
    }
}

