/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.operation;

import java.io.Serializable;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Picture.RecomputeViews", category="Services", label="Recompute Picture Views", description="Recompute the picture views of the documents resulting from the provided NXQL query.", since="10.3")
public class RecomputePictureViews {
    public static final String ID = "Picture.RecomputeViews";
    public static final String DEFAULT_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Picture' AND picture:views/*/title IS NULL";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="query", description="NXQL query to collect the documents whose picture views to recompute.", values={"SELECT * FROM Document WHERE ecm:mixinType = 'Picture' AND picture:views/*/title IS NULL"})
    protected String query;

    @OperationMethod
    public void run() {
        BulkService service = (BulkService)Framework.getService(BulkService.class);
        String username = this.ctx.getPrincipal().getName();
        service.submit(new BulkCommand.Builder("recomputeViewsBackground", this.query, username).orElseAction("recomputeViews").param("xpath", (Serializable)((Object)"file:content")).build());
    }
}

