/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.recompute;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DownloadBlobGuard;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.picture.PictureViewsHelper;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class RecomputeViewsAction
implements StreamProcessorTopology {
    private static final Logger log = LogManager.getLogger(RecomputeViewsAction.class);
    public static final String ACTION_NAME = "recomputeViews";
    public static final String ACTION_NAME_BG = "recomputeViewsBackground";
    public static final String ACTION_FULL_NAME = "bulk/recomputeViews";
    public static final String PARAM_XPATH = "xpath";

    public Topology getTopology(Map<String, String> options) {
        String actionName = "bulk/" + Objects.requireNonNullElse(options.get("processorName"), ACTION_NAME);
        return Topology.builder().addComputation(() -> new RecomputeViewsComputation(actionName), Arrays.asList("i1:" + actionName, "o1:bulk/status")).build();
    }

    public static class RecomputeViewsComputation
    extends AbstractBulkComputation {
        public static final String PICTURE_VIEWS_GENERATION_DONE_EVENT = "pictureViewsGenerationDone";
        protected PictureViewsHelper pictureViewsHelper = new PictureViewsHelper();
        protected String xpath;
        protected String lastPictureViewsStatus;

        public RecomputeViewsComputation(String name) {
            super(name);
        }

        public RecomputeViewsComputation() {
            super(RecomputeViewsAction.ACTION_FULL_NAME);
        }

        public void startBucket(String bucketKey) {
            BulkCommand command = this.getCurrentCommand();
            this.xpath = (String)command.getParam(RecomputeViewsAction.PARAM_XPATH);
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            log.debug("Compute action: {} for doc ids: {}", (Object)RecomputeViewsAction.ACTION_NAME, ids);
            for (String docId : ids) {
                this.pictureViewsHelper.newTransaction();
                this.pictureViewsHelper.computePictureViews(session, docId, this.xpath, this::setLastPictureViewsStatus);
                if (!"Nothing to process".equals(this.getLastPictureViewsStatus())) {
                    this.fireEvent(session, session.getDocument((DocumentRef)new IdRef(docId)), PICTURE_VIEWS_GENERATION_DONE_EVENT);
                }
                DownloadBlobGuard.enable();
            }
        }

        protected void setLastPictureViewsStatus(String status) {
            this.lastPictureViewsStatus = status;
        }

        protected String getLastPictureViewsStatus() {
            return this.lastPictureViewsStatus;
        }

        protected void fireEvent(CoreSession session, DocumentModel document, String eventName) {
            DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), document);
            Event event = ctx.newEvent(eventName);
            ((EventService)Framework.getService(EventService.class)).fireEvent(event);
        }
    }
}

