/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.nuxeo.ecm.automation.LoginStack;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class OperationContext
extends AbstractMap<String, Object>
implements AutoCloseable {
    protected boolean commit = true;
    protected boolean handleTransaction = true;
    protected final Map<String, Object> vars;
    protected final Map<String, Deque<Object>> stacks = new HashMap<String, Deque<Object>>();
    protected LoginStack loginStack;
    protected Object input;
    protected List<String> trace;
    protected OperationCallback callback;

    public OperationContext() {
        this(null);
    }

    public OperationContext(CoreSession session) {
        this(session, new HashMap<String, Object>());
    }

    protected OperationContext(CoreSession session, Map<String, Object> bindings) {
        this.vars = bindings;
        this.loginStack = new LoginStack(session);
        this.trace = new ArrayList<String>();
        this.callback = ((TracerFactory)Framework.getService(TracerFactory.class)).newTracer();
    }

    public void setCoreSession(CoreSession session) {
        this.loginStack.setSession(session);
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public boolean isCommit() {
        return this.commit && this.handleTransaction && !TransactionHelper.isTransactionMarkedRollback();
    }

    public OperationContext handleTransaction(boolean handleTransaction) {
        this.handleTransaction = handleTransaction;
        return this;
    }

    public CoreSession getCoreSession() {
        return this.loginStack.getSession();
    }

    public LoginStack getLoginStack() {
        return this.loginStack;
    }

    public NuxeoPrincipal getPrincipal() {
        CoreSession session = this.loginStack.getSession();
        return session != null ? session.getPrincipal() : null;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public void push(String type, Object obj) {
        this.stacks.computeIfAbsent(type, key -> new LinkedList()).push(obj);
    }

    public Object peek(String type) {
        return Optional.ofNullable(this.stacks.get(type)).map(Deque::peek).orElse(null);
    }

    public Object pop(String type) {
        return Optional.ofNullable(this.stacks.get(type)).map(stack -> {
            Object obj = stack.pop();
            if (stack.isEmpty()) {
                this.stacks.remove(type);
            }
            return obj;
        }).orElse(null);
    }

    public Object pull(String type) {
        return Optional.ofNullable(this.stacks.get(type)).map(stack -> {
            Object obj = stack.removeLast();
            if (stack.isEmpty()) {
                this.stacks.remove(type);
            }
            return obj;
        }).orElse(null);
    }

    public <T> T getAdapter(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(CoreSession.class)) {
            return type.cast(this.getCoreSession());
        }
        if (type.isAssignableFrom(NuxeoPrincipal.class)) {
            return type.cast(this.getPrincipal());
        }
        return (T)Framework.getService(type);
    }

    @Override
    public void close() {
        if (this.getCoreSession() != null && this.isCommit()) {
            this.getCoreSession().save();
        }
        this.trace.clear();
        this.loginStack.clear();
    }

    public void setRollback() {
        if (this.handleTransaction) {
            this.setCommit(false);
            TransactionHelper.setTransactionRollbackOnly();
        }
    }

    public Map<String, Object> getVars() {
        return this.vars;
    }

    @Override
    public Object get(Object key) {
        return this.resolve(this.vars.get(key));
    }

    @Override
    public Object put(String key, Object value) {
        if ("ChainParameters".equals(key)) {
            throw new IllegalArgumentException("ChainParameters is reserved, not writable");
        }
        return this.resolve(this.vars.put(key, value));
    }

    @Override
    public Object remove(Object key) {
        if ("ChainParameters".equals(key)) {
            throw new IllegalArgumentException("ChainParameters is reserved, not writable");
        }
        return this.resolve(this.vars.remove(key));
    }

    public Map<String, Object> getChainParameters() {
        return this.vars.getOrDefault("ChainParameters", new HashMap());
    }

    public Map<String, Object> putChainParameters(Map<String, ?> parameters) {
        return this.vars.put("ChainParameters", parameters);
    }

    public Map<String, Object> removeChainParameters() {
        return (Map)this.vars.remove("ChainParameters");
    }

    public Object getChainParameter(String key) {
        return Optional.ofNullable(this.getChainParameters().get(key)).map(this::resolve).orElse(this.get(key));
    }

    public <T> T callWithChainParameters(Callable<T> callable, Map<String, Object> parameters) throws OperationException {
        Callable<Map> initialize = () -> {
            Map<String, Object> initialParameters = this.getChainParameters();
            HashMap<String, Object> mergedParameters = new HashMap<String, Object>();
            mergedParameters.putAll(initialParameters);
            mergedParameters.putAll(parameters);
            this.putChainParameters(mergedParameters);
            return initialParameters;
        };
        Consumer<Map> restore = this::putChainParameters;
        return this.call(callable, initialize, restore);
    }

    public <T> T callWithContextVar(Callable<T> callable, String key, Object value) throws OperationException {
        Callable<Object> initialize = () -> {
            Object initialValue = this.vars.get(key);
            this.vars.put(key, value);
            return initialValue;
        };
        Consumer<Object> restore = initialValue -> {
            if (initialValue == null) {
                this.vars.remove(key);
            } else {
                this.vars.put(key, initialValue);
            }
        };
        return this.call(callable, initialize, restore);
    }

    protected <T, U> T call(Callable<T> callable, Callable<U> initialize, Consumer<U> restore) throws OperationException {
        Object initialState = null;
        try {
            initialState = initialize.call();
            T t = callable.call();
            return t;
        }
        catch (OperationException | NuxeoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OperationException(e);
        }
        finally {
            restore.accept(initialState);
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                final Iterator<Map.Entry<String, Object>> iterator = OperationContext.this.vars.entrySet().iterator();
                return new Iterator<Map.Entry<String, Object>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        final Map.Entry entry = (Map.Entry)iterator.next();
                        return new Map.Entry<String, Object>(){

                            @Override
                            public String getKey() {
                                return (String)entry.getKey();
                            }

                            @Override
                            public Object getValue() {
                                return OperationContext.this.resolve(entry.getValue());
                            }

                            @Override
                            public Object setValue(Object value) {
                                Object previous = entry.setValue(value);
                                return OperationContext.this.resolve(previous);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return OperationContext.this.vars.size();
            }
        };
    }

    public OperationCallback getCallback() {
        return this.callback;
    }

    public void setCallback(OperationCallback chainCallback) {
        this.callback = chainCallback;
    }

    public OperationContext getSubContext(boolean isolate, Object input) {
        Map<String, Object> subVars = isolate ? new HashMap<String, Object>(this.getVars()) : this.getVars();
        OperationContext subctx = new OperationContext(this.getCoreSession(), subVars);
        subctx.setInput(input);
        subctx.setCallback(this.callback);
        return subctx;
    }

    public OperationContext getSubContext(boolean isolate) {
        return this.getSubContext(isolate, this.getInput());
    }

    public Object resolve(Object obj) {
        if (!(obj instanceof Expression)) {
            return obj;
        }
        return ((Expression)obj).eval(this);
    }
}

