/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl.adapters;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.TypeAdaptException;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.util.Properties;

public class JsonNodeToProperties
implements TypeAdapter {
    @Override
    public Object getAdaptedValue(OperationContext ctx, Object objectToAdapt) throws TypeAdaptException {
        JsonNode json = (JsonNode)objectToAdapt;
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator it = json.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isArray()) {
                int size = value.size();
                if (size == 0) {
                    map.put(key, null);
                    continue;
                }
                if (size == 1) {
                    map.put(key, value.get(0).asText());
                    continue;
                }
                StringBuilder sb = new StringBuilder(size * 32);
                sb.append(value.get(0).asText());
                for (int i = 1; i < size; ++i) {
                    sb.append(',').append(value.get(i).asText());
                }
                map.put(key, sb.toString());
                continue;
            }
            if (value.isTextual()) {
                map.put(key, value.textValue());
                continue;
            }
            map.put(key, value.toString());
        }
        return new Properties((Map<String, String>)map);
    }
}

