/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CursorResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.ScrollResultImpl;

public class CursorService<C, O, R> {
    private static final Log log = LogFactory.getLog(CursorService.class);
    protected final Map<String, CursorResult<C, O>> cursorResults = new ConcurrentHashMap<String, CursorResult<C, O>>();
    protected final Function<O, R> extractor;

    public CursorService(Function<O, R> extractor) {
        this.extractor = extractor;
    }

    public void checkForTimedOutScroll() {
        this.cursorResults.forEach(this::isScrollTimedOut);
    }

    protected boolean isScrollTimedOut(String scrollId, CursorResult<C, O> cursorResult) {
        if (cursorResult.timedOut()) {
            if (this.unregisterCursor(scrollId)) {
                log.warn((Object)("Scroll '" + scrollId + "' timed out, (now: " + System.currentTimeMillis() + " - last: " + cursorResult.lastCallTimestamp + ") > keepalive: 1000*" + cursorResult.keepAliveSeconds));
            }
            return true;
        }
        return false;
    }

    public String registerCursor(C cursor, int batchSize, int keepAliveSeconds) {
        return this.registerCursorResult(new CursorResult(cursor, batchSize, keepAliveSeconds));
    }

    public String registerCursor(String scrollId, C cursor, int batchSize, int keepAliveSeconds) {
        return this.registerCursorResult(scrollId, new CursorResult(cursor, batchSize, keepAliveSeconds));
    }

    public String registerCursorResult(CursorResult<C, O> cursorResult) {
        String scrollId = UUID.randomUUID().toString();
        return this.registerCursorResult(scrollId, cursorResult);
    }

    public String registerCursorResult(String scrollId, CursorResult<C, O> cursorResult) {
        this.cursorResults.put(scrollId, cursorResult);
        if (log.isDebugEnabled()) {
            log.debug((Object)("registerCursorResult Scroll: " + scrollId + ", keepalive: " + cursorResult.keepAliveSeconds));
        }
        return scrollId;
    }

    public boolean unregisterCursor(String scrollId) {
        CursorResult<C, O> cursorResult = this.cursorResults.remove(scrollId);
        if (cursorResult != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("unregisterCursor Scroll: " + scrollId));
            }
            cursorResult.close();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollResult<R> scroll(String scrollId) {
        CursorResult<C, O> cursorResult = this.cursorResults.get(scrollId);
        if (cursorResult == null) {
            throw new NuxeoException("Unknown or timed out scrollId: " + scrollId);
        }
        if (this.isScrollTimedOut(scrollId, cursorResult)) {
            throw new NuxeoException("Timed out scrollId: " + scrollId);
        }
        cursorResult.touch();
        ArrayList<R> results = new ArrayList<R>(cursorResult.getBatchSize());
        CursorResult<C, O> cursorResult2 = cursorResult;
        synchronized (cursorResult2) {
            if (!cursorResult.hasNext()) {
                this.unregisterCursor(scrollId);
                return ScrollResultImpl.emptyResult();
            }
            while (results.size() < cursorResult.getBatchSize()) {
                if (!cursorResult.hasNext()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing cursor for Scroll: " + scrollId));
                    }
                    cursorResult.close();
                    break;
                }
                O obj = cursorResult.next();
                R result = this.extractor.apply(obj);
                if (result == null) {
                    log.error((Object)("Got a document without result: " + obj + " Scroll: " + scrollId));
                    continue;
                }
                results.add(result);
            }
        }
        return new ScrollResultImpl(scrollId, results);
    }

    public void clear() {
        Iterator<CursorResult<C, O>> values = this.cursorResults.values().iterator();
        while (values.hasNext()) {
            values.next().close();
            values.remove();
        }
    }
}

