/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.text.Collator;
import java.util.Calendar;
import java.util.Map;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.Sorter;

public class DocumentModelComparator
implements Sorter {
    private static final long serialVersionUID = 1L;
    public static final String ORDER_ASC = "asc";
    static final Collator collator = Collator.getInstance();
    final String schemaName;
    final Map<String, String> orderBy;

    public DocumentModelComparator(String schemaName, Map<String, String> orderBy) {
        this.schemaName = schemaName;
        this.orderBy = orderBy;
    }

    public DocumentModelComparator(Map<String, String> orderBy) {
        this(null, orderBy);
    }

    protected int compare(Object v1, Object v2, boolean asc) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return asc ? -1 : 1;
        }
        if (v2 == null) {
            return asc ? 1 : -1;
        }
        int cmp = v1 instanceof Long && v2 instanceof Long ? ((Long)v1).compareTo((Long)v2) : (v1 instanceof Integer && v2 instanceof Integer ? ((Integer)v1).compareTo((Integer)v2) : (v1 instanceof Calendar && v2 instanceof Calendar ? ((Calendar)v1).compareTo((Calendar)v2) : collator.compare(v1.toString(), v2.toString())));
        return asc ? cmp : -cmp;
    }

    @Override
    public int compare(DocumentModel doc1, DocumentModel doc2) {
        if (doc1 == null && doc2 == null) {
            return 0;
        }
        if (doc1 == null) {
            return -1;
        }
        if (doc2 == null) {
            return 1;
        }
        int cmp = 0;
        if (this.schemaName != null) {
            DataModel d1 = doc1.getDataModel(this.schemaName);
            DataModel d2 = doc2.getDataModel(this.schemaName);
            for (Map.Entry<String, String> e : this.orderBy.entrySet()) {
                Object v2;
                String fieldName = e.getKey();
                boolean asc = ORDER_ASC.equals(e.getValue());
                Object v1 = d1.getData(fieldName);
                cmp = this.compare(v1, v2 = d2.getData(fieldName), asc);
                if (cmp == 0) continue;
                break;
            }
        } else {
            for (Map.Entry<String, String> e : this.orderBy.entrySet()) {
                String propertyName = e.getKey();
                boolean asc = ORDER_ASC.equals(e.getValue());
                Serializable v1 = null;
                try {
                    v1 = doc1.getPropertyValue(propertyName);
                }
                catch (PropertyException pe) {
                    v1 = null;
                }
                Serializable v2 = null;
                try {
                    v2 = doc2.getPropertyValue(propertyName);
                }
                catch (PropertyException pe) {
                    v2 = null;
                }
                if ((cmp = this.compare(v1, v2, asc)) == 0) continue;
                break;
            }
        }
        if (cmp == 0) {
            cmp = doc1.hashCode() == doc2.hashCode() ? 0 : (doc1.hashCode() < doc2.hashCode() ? -1 : 1);
        }
        return cmp;
    }

    static {
        collator.setStrength(0);
    }
}

