/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;

@XObject(value="adapter")
public class DocumentAdapterDescriptor {
    private static final Log log = LogFactory.getLog(DocumentAdapterDescriptor.class);
    @XNode(value="@facet")
    private String facet;
    @XNode(value="@class")
    private Class<?> itf;
    private DocumentAdapterFactory factory;

    public DocumentAdapterDescriptor() {
    }

    public DocumentAdapterDescriptor(String facet, Class<?> itf, DocumentAdapterFactory factory) {
        this.facet = facet;
        this.itf = itf;
        this.factory = factory;
    }

    @XNode(value="@factory")
    void setFactory(Class<DocumentAdapterFactory> factoryClass) throws ReflectiveOperationException {
        try {
            this.factory = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)"ERROR instantiating document adapter factory class!");
            throw e;
        }
    }

    public DocumentAdapterFactory getFactory() {
        return this.factory;
    }

    public void setFactory(DocumentAdapterFactory factory) {
        this.factory = factory;
    }

    public String getFacet() {
        return this.facet;
    }

    public void setFacet(String facet) {
        this.facet = facet;
    }

    public Class<?> getInterface() {
        return this.itf;
    }

    public void setInterface(Class<?> itf) {
        this.itf = itf;
    }

    public String toString() {
        return this.facet + ": " + this.itf;
    }
}

