/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;

public abstract class AbstractBlobHolder
implements BlobHolder {
    @Override
    public void setBlob(Blob blob) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Blob> getBlobs() {
        ArrayList<Blob> blobs = null;
        Blob blob = this.getBlob();
        if (blob != null) {
            blobs = new ArrayList<Blob>();
            blobs.add(blob);
        }
        return blobs;
    }

    protected abstract String getBasePath();

    @Override
    public String getFilePath() {
        Object path = this.getBasePath();
        Blob blob = this.getBlob();
        if (blob != null) {
            path = (String)path + "/" + blob.getFilename();
        }
        return path;
    }

    @Override
    public String getHash() {
        Blob blob = this.getBlob();
        if (blob != null) {
            String h = blob.getDigest();
            if (h == null) {
                h = this.getMD5Digest();
                blob.setDigest(h);
            }
            return h;
        }
        return "NullBlob";
    }

    protected String getMD5Digest() {
        String string;
        block8: {
            InputStream in = this.getBlob().getStream();
            try {
                string = DigestUtils.md5Hex((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NuxeoException(e);
                }
            }
            in.close();
        }
        return string;
    }
}

